
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_carry_save_adder_tree08 is
  generic( 
    WIDTH: integer
  );
  port( 
    inp  :  in std_logic_vector(WIDTH-1 downto 0);
    en   :  in std_logic_vector(7 downto 0);		
    sum  : out std_logic_vector(WIDTH+6 downto 0);
    cin  :  in std_logic;
    cout : out std_logic;
    out0 : out std_logic_vector(WIDTH+7 downto 0);
    out1 : out std_logic_vector(WIDTH+7 downto 0)
  );
end nacl_carry_save_adder_tree08;

architecture behaviour of nacl_carry_save_adder_tree08 is 
 
  signal en0          : std_logic_vector(WIDTH-1 downto 0);
  signal en1          : std_logic_vector(WIDTH-1 downto 0);
  signal en2          : std_logic_vector(WIDTH-1 downto 0);
  signal en3          : std_logic_vector(WIDTH-1 downto 0);
  signal en4          : std_logic_vector(WIDTH-1 downto 0);
  signal en5          : std_logic_vector(WIDTH-1 downto 0);
  signal en6          : std_logic_vector(WIDTH-1 downto 0);
  signal en7          : std_logic_vector(WIDTH-1 downto 0);
 
  signal adder0_a     : std_logic_vector(WIDTH+1 downto 0);
  signal adder0_b     : std_logic_vector(WIDTH+1 downto 0);
  signal adder0_c     : std_logic_vector(WIDTH+1 downto 0);
  signal adder0_sum   : std_logic_vector(WIDTH+1 downto 0);
  signal adder0_carry : std_logic_vector(WIDTH+1 downto 0);
  
  signal adder1_a     : std_logic_vector(WIDTH-1 downto 0);
  signal adder1_b     : std_logic_vector(WIDTH-1 downto 0);
  signal adder1_c     : std_logic_vector(WIDTH-1 downto 0);
  signal adder1_sum   : std_logic_vector(WIDTH-1 downto 0);
  signal adder1_carry : std_logic_vector(WIDTH-1 downto 0);
  
  signal adder2_a     : std_logic_vector(WIDTH+1 downto 0);
  signal adder2_b     : std_logic_vector(WIDTH+1 downto 0);
  signal adder2_c     : std_logic_vector(WIDTH+1 downto 0);
  signal adder2_sum   : std_logic_vector(WIDTH+1 downto 0);
  signal adder2_carry : std_logic_vector(WIDTH+1 downto 0);
  
  signal adder3_a     : std_logic_vector(WIDTH-1 downto 0);
  signal adder3_b     : std_logic_vector(WIDTH-1 downto 0);
  signal adder3_c     : std_logic_vector(WIDTH-1 downto 0);
  signal adder3_sum   : std_logic_vector(WIDTH-1 downto 0);
  signal adder3_carry : std_logic_vector(WIDTH-1 downto 0);
  
  signal adder4_a     : std_logic_vector(WIDTH+2 downto 0);
  signal adder4_b     : std_logic_vector(WIDTH+2 downto 0);
  signal adder4_c     : std_logic_vector(WIDTH+2 downto 0);
  signal adder4_sum   : std_logic_vector(WIDTH+2 downto 0);
  signal adder4_carry : std_logic_vector(WIDTH+2 downto 0);
  signal adder4_cout  : std_logic;
  
  signal adder5_a     : std_logic_vector(WIDTH+3 downto 0);
  signal adder5_b     : std_logic_vector(WIDTH+3 downto 0);
  signal adder5_c     : std_logic_vector(WIDTH+3 downto 0);
  signal adder5_sum   : std_logic_vector(WIDTH+3 downto 0);
  signal adder5_carry : std_logic_vector(WIDTH+3 downto 0);
  signal adder5_cout  : std_logic;
  
  signal adder6a_a     : std_logic_vector(3 downto 0);
  signal adder6a_b     : std_logic_vector(3 downto 0);
  signal adder6a_sum   : std_logic_vector(3 downto 0);
  signal adder6a_cout  : std_logic;
  
  signal adder6b_a     : std_logic_vector(WIDTH+3 downto 0);
  signal adder6b_b     : std_logic_vector(WIDTH+3 downto 0);
  signal adder6b_sum   : std_logic_vector(WIDTH+3 downto 0);
  signal adder6b_cin   : std_logic;
  
begin
  
  adder0 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+2
  )
  port map( 
    a     => adder0_a,
    b     => adder0_b,
    c     => adder0_c,
    sum   => adder0_sum,
    carry => adder0_carry,
    cin   => '0',
    cout  => open
  );
  
  adder1 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH
  )
  port map( 
    a     => adder1_a,
    b     => adder1_b,
    c     => adder1_c,
    sum   => adder1_sum,
    carry => adder1_carry,
    cin   => '0',
    cout  => open
  );
  
  adder2 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+2
  )
  port map( 
    a     => adder2_a,
    b     => adder2_b,
    c     => adder2_c,
    sum   => adder2_sum,
    carry => adder2_carry,
    cin   => '0',
    cout  => open
  );
  
  adder3 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH
  )
  port map( 
    a     => adder3_a,
    b     => adder3_b,
    c     => adder3_c,
    sum   => adder3_sum,
    carry => adder3_carry,
    cin   => '0',
    cout  => open
  );
  
  adder4 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+3
  )
  port map( 
    a     => adder4_a,
    b     => adder4_b,
    c     => adder4_c,
    sum   => adder4_sum,
    carry => adder4_carry,
    cin   => '0',
    cout  => adder4_cout
  );
  
  adder5 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+4
  )
  port map( 
    a     => adder5_a,
    b     => adder5_b,
    c     => adder5_c,
    sum   => adder5_sum,
    carry => adder5_carry,
    cin   => '0',
    cout  => adder5_cout
  );
  
  adder6a : entity work.nacl_adder
  generic map( 
    WIDTH => 4
  )
  port map( 
    a     => adder6a_a,
    b     => adder6a_b,
    sum   => adder6a_sum,
    cin   => cin,
    cout  => adder6a_cout
  );
  
  adder6b : entity work.nacl_adder
  generic map( 
    WIDTH => WIDTH+4
  )
  port map( 
    a     => adder6b_a,
    b     => adder6b_b,
    sum   => adder6b_sum,
    cin   => adder6b_cin,
    cout  => open
  );
  
  en0 <= (others => en(0));
  en1 <= (others => en(1));
  en2 <= (others => en(2));
  en3 <= (others => en(3));
  en4 <= (others => en(4));
  en5 <= (others => en(5));
  en6 <= (others => en(6));
  en7 <= (others => en(7));

  adder0_a    <= "00" & (inp and en0);
  adder0_b    <= '0'  & (inp and en1) & '0';
  adder0_c    <=        (inp and en2) & "00";

  adder1_a    <= '0' & adder0_sum(WIDTH+1 downto 3);
  adder1_b    <= '0' & adder0_carry(WIDTH+1 downto 3);
  adder1_c    <= inp and en3;
  
  adder2_a    <= "00" & (inp and en4);
  adder2_b    <= '0'  & (inp and en5) & '0';
  adder2_c    <=        (inp and en6) & "00";

  adder3_a    <= '0' & adder2_sum(WIDTH+1 downto 3);
  adder3_b    <= '0' & adder2_carry(WIDTH+1 downto 3);
  adder3_c    <= inp and en7;
  
  adder4_a    <= adder3_sum & adder2_sum(2 downto 0);
  adder4_b    <= "0000" & adder1_sum(WIDTH-1 downto 1);
  adder4_c    <= "0000" & adder1_carry(WIDTH-1 downto 1);
  
  adder5_a    <= '0' & adder4_sum;
  adder5_b    <= adder4_cout & adder4_carry;
  adder5_c    <= '0' & adder3_carry & adder2_carry(2 downto 0);
  
  adder6a_a   <= adder1_sum(0) & adder0_sum(2 downto 0);
  adder6a_b   <= adder1_carry(0) & adder0_carry(2 downto 0);
  
  adder6b_a   <= adder5_sum;
  adder6b_b   <= adder5_carry;
  adder6b_cin <= adder6a_cout;
  
  sum  <= adder6b_sum(WIDTH+2 downto 0) & adder6a_sum;
  cout <= adder6b_sum(WIDTH+3);
  
  out0 <= adder5_sum & adder1_sum(0) & adder0_sum(2 downto 0);
  out1 <= adder5_carry & adder1_carry(0) & adder0_carry(2 downto 0);
  
end;
