
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_carry_save_adder_tree11 is
  generic( 
    WIDTH: integer
  );
  port( 
    inp  :  in std_logic_vector(WIDTH-1 downto 0);
    en   :  in std_logic_vector(10 downto 0);		
    sum  : out std_logic_vector(WIDTH+9 downto 0);
    cin  :  in std_logic;
    cout : out std_logic       
  );
end nacl_carry_save_adder_tree11;

architecture behaviour of nacl_carry_save_adder_tree11 is 
 
  signal en0          : std_logic_vector(WIDTH-1 downto 0);
  signal en1          : std_logic_vector(WIDTH-1 downto 0);
  signal en2          : std_logic_vector(WIDTH-1 downto 0);
  signal en3          : std_logic_vector(WIDTH-1 downto 0);
  signal en4          : std_logic_vector(WIDTH-1 downto 0);
  signal en5          : std_logic_vector(WIDTH-1 downto 0);
  signal en6          : std_logic_vector(WIDTH-1 downto 0);
  signal en7          : std_logic_vector(WIDTH-1 downto 0);
  signal en8          : std_logic_vector(WIDTH-1 downto 0);
  signal en9          : std_logic_vector(WIDTH-1 downto 0);
  signal enA          : std_logic_vector(WIDTH-1 downto 0);
 
  signal adder0_a     : std_logic_vector(WIDTH+1 downto 0);
  signal adder0_b     : std_logic_vector(WIDTH+1 downto 0);
  signal adder0_c     : std_logic_vector(WIDTH+1 downto 0);
  signal adder0_sum   : std_logic_vector(WIDTH+1 downto 0);
  signal adder0_carry : std_logic_vector(WIDTH+1 downto 0);
  
  signal adder1_a     : std_logic_vector(WIDTH-1 downto 0);
  signal adder1_b     : std_logic_vector(WIDTH-1 downto 0);
  signal adder1_c     : std_logic_vector(WIDTH-1 downto 0);
  signal adder1_sum   : std_logic_vector(WIDTH-1 downto 0);
  signal adder1_carry : std_logic_vector(WIDTH-1 downto 0);
  
  signal adder2_a     : std_logic_vector(WIDTH+1 downto 0);
  signal adder2_b     : std_logic_vector(WIDTH+1 downto 0);
  signal adder2_c     : std_logic_vector(WIDTH+1 downto 0);
  signal adder2_sum   : std_logic_vector(WIDTH+1 downto 0);
  signal adder2_carry : std_logic_vector(WIDTH+1 downto 0);
  
  signal adder3_a     : std_logic_vector(WIDTH-1 downto 0);
  signal adder3_b     : std_logic_vector(WIDTH-1 downto 0);
  signal adder3_c     : std_logic_vector(WIDTH-1 downto 0);
  signal adder3_sum   : std_logic_vector(WIDTH-1 downto 0);
  signal adder3_carry : std_logic_vector(WIDTH-1 downto 0);
  
  signal adder4_a     : std_logic_vector(WIDTH+2 downto 0);
  signal adder4_b     : std_logic_vector(WIDTH+2 downto 0);
  signal adder4_c     : std_logic_vector(WIDTH+2 downto 0);
  signal adder4_sum   : std_logic_vector(WIDTH+2 downto 0);
  signal adder4_carry : std_logic_vector(WIDTH+2 downto 0);
  signal adder4_cout  : std_logic;
  
  signal adder5_a     : std_logic_vector(WIDTH+3 downto 0);
  signal adder5_b     : std_logic_vector(WIDTH+3 downto 0);
  signal adder5_c     : std_logic_vector(WIDTH+3 downto 0);
  signal adder5_sum   : std_logic_vector(WIDTH+3 downto 0);
  signal adder5_carry : std_logic_vector(WIDTH+3 downto 0);
  signal adder5_cout  : std_logic;
  
  signal adder6_a     : std_logic_vector(WIDTH+1 downto 0);
  signal adder6_b     : std_logic_vector(WIDTH+1 downto 0);
  signal adder6_c     : std_logic_vector(WIDTH+1 downto 0);
  signal adder6_sum   : std_logic_vector(WIDTH+1 downto 0);
  signal adder6_carry : std_logic_vector(WIDTH+1 downto 0);
  signal adder6_cout  : std_logic;
  
  signal adder7_a     : std_logic_vector(WIDTH+6 downto 0);
  signal adder7_b     : std_logic_vector(WIDTH+6 downto 0);
  signal adder7_c     : std_logic_vector(WIDTH+6 downto 0);
  signal adder7_sum   : std_logic_vector(WIDTH+6 downto 0);
  signal adder7_carry : std_logic_vector(WIDTH+6 downto 0);
  signal adder7_cout  : std_logic;
  
  signal adder8_a     : std_logic_vector(WIDTH+7 downto 0);
  signal adder8_b     : std_logic_vector(WIDTH+7 downto 0);
  signal adder8_c     : std_logic_vector(WIDTH+7 downto 0);
  signal adder8_sum   : std_logic_vector(WIDTH+7 downto 0);
  signal adder8_carry : std_logic_vector(WIDTH+7 downto 0);
  signal adder8_cout  : std_logic;
  
  signal adder9a_a     : std_logic_vector(3 downto 0);
  signal adder9a_b     : std_logic_vector(3 downto 0);
  signal adder9a_sum   : std_logic_vector(3 downto 0);
  signal adder9a_cout  : std_logic;
  
  signal adder9b_a     : std_logic_vector(WIDTH+7 downto 0);
  signal adder9b_b     : std_logic_vector(WIDTH+7 downto 0);
  signal adder9b_sum   : std_logic_vector(WIDTH+7 downto 0);
  signal adder9b_cin   : std_logic;
  
begin
  
  adder0 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+2
  )
  port map( 
    a     => adder0_a,
    b     => adder0_b,
    c     => adder0_c,
    sum   => adder0_sum,
    carry => adder0_carry,
    cin   => '0',
    cout  => open
  );
  
  adder1 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH
  )
  port map( 
    a     => adder1_a,
    b     => adder1_b,
    c     => adder1_c,
    sum   => adder1_sum,
    carry => adder1_carry,
    cin   => '0',
    cout  => open
  );
  
  adder2 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+2
  )
  port map( 
    a     => adder2_a,
    b     => adder2_b,
    c     => adder2_c,
    sum   => adder2_sum,
    carry => adder2_carry,
    cin   => '0',
    cout  => open
  );
  
  adder3 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH
  )
  port map( 
    a     => adder3_a,
    b     => adder3_b,
    c     => adder3_c,
    sum   => adder3_sum,
    carry => adder3_carry,
    cin   => '0',
    cout  => open
  );
  
  adder4 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+3
  )
  port map( 
    a     => adder4_a,
    b     => adder4_b,
    c     => adder4_c,
    sum   => adder4_sum,
    carry => adder4_carry,
    cin   => '0',
    cout  => adder4_cout
  );
  
  adder5 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+4
  )
  port map( 
    a     => adder5_a,
    b     => adder5_b,
    c     => adder5_c,
    sum   => adder5_sum,
    carry => adder5_carry,
    cin   => '0',
    cout  => adder5_cout
  );
  
  adder6 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+2
  )
  port map( 
    a     => adder6_a,
    b     => adder6_b,
    c     => adder6_c,
    sum   => adder6_sum,
    carry => adder6_carry,
    cin   => '0',
    cout  => adder6_cout
  );
  
  adder7 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+7
  )
  port map( 
    a     => adder7_a,
    b     => adder7_b,
    c     => adder7_c,
    sum   => adder7_sum,
    carry => adder7_carry,
    cin   => '0',
    cout  => adder7_cout
  );
  
  adder8 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+8
  )
  port map( 
    a     => adder8_a,
    b     => adder8_b,
    c     => adder8_c,
    sum   => adder8_sum,
    carry => adder8_carry,
    cin   => '0',
    cout  => adder8_cout
  );
  
  adder9a : entity work.nacl_adder
  generic map( 
    WIDTH => 4
  )
  port map( 
    a     => adder9a_a,
    b     => adder9a_b,
    sum   => adder9a_sum,
    cin   => cin,
    cout  => adder9a_cout
  );
  
  adder9b : entity work.nacl_adder
  generic map( 
    WIDTH => WIDTH+8
  )
  port map( 
    a     => adder9b_a,
    b     => adder9b_b,
    sum   => adder9b_sum,
    cin   => adder9b_cin,
    cout  => open
  );
  
  en0 <= (others => en(0));
  en1 <= (others => en(1));
  en2 <= (others => en(2));
  en3 <= (others => en(3));
  en4 <= (others => en(4));
  en5 <= (others => en(5));
  en6 <= (others => en(6));
  en7 <= (others => en(7));
  en8 <= (others => en(8));
  en9 <= (others => en(9));
  enA <= (others => en(10));

  adder0_a    <= "00" & (inp and en0);
  adder0_b    <= '0'  & (inp and en1) & '0';
  adder0_c    <=        (inp and en2) & "00";

  adder1_a    <= '0' & adder0_sum(WIDTH+1 downto 3);
  adder1_b    <= '0' & adder0_carry(WIDTH+1 downto 3);
  adder1_c    <= inp and en3;
  
  adder2_a    <= "00" & (inp and en4);
  adder2_b    <= '0'  & (inp and en5) & '0';
  adder2_c    <=        (inp and en6) & "00";

  adder3_a    <= '0' & adder2_sum(WIDTH+1 downto 3);
  adder3_b    <= '0' & adder2_carry(WIDTH+1 downto 3);
  adder3_c    <= inp and en7;
  
  adder4_a    <= adder3_sum & adder2_sum(2 downto 0);
  adder4_b    <= "0000" & adder1_sum(WIDTH-1 downto 1);
  adder4_c    <= "0000" & adder1_carry(WIDTH-1 downto 1);
  
  adder5_a    <= '0' & adder4_sum;
  adder5_b    <= adder4_cout & adder4_carry;
  adder5_c    <= '0' & adder3_carry & adder2_carry(2 downto 0);
  
  adder6_a    <= "00" & (inp and en8);
  adder6_b    <= '0'  & (inp and en9) & '0';
  adder6_c    <=        (inp and enA) & "00";
  
  adder7_a    <= "000" & adder5_sum;
  adder7_b    <= "00" & adder5_cout & adder5_carry;
  adder7_c    <= '0' & adder6_sum & "0000";
  
  adder8_a    <= '0' & adder7_sum;
  adder8_b    <= adder7_cout & adder7_carry;
  adder8_c    <= '0' & adder6_cout & adder6_carry & "0000";
  
  adder9a_a   <= adder1_sum(0) & adder0_sum(2 downto 0);
  adder9a_b   <= adder1_carry(0) & adder0_carry(2 downto 0);
  
  adder9b_a   <= adder8_sum;
  adder9b_b   <= adder8_carry;
  adder9b_cin <= adder9a_cout;
  
  sum  <=  adder9b_sum(WIDTH+5 downto 0) & adder9a_sum;
  cout <= adder9b_sum(WIDTH+6);
  
end;
