
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_carry_save_adder_tree16 is
  generic( 
    WIDTH: integer
  );
  port( 
    inp  :  in std_logic_vector(WIDTH-1 downto 0);
    en   :  in std_logic_vector(15 downto 0);		
    sum  : out std_logic_vector(WIDTH+14 downto 0);
    cin  :  in std_logic;
    cout : out std_logic       
  );
end nacl_carry_save_adder_tree16;

architecture behaviour of nacl_carry_save_adder_tree16 is 
 
  signal en0    : std_logic_vector(7 downto 0);
  signal en1    : std_logic_vector(7 downto 0);

  signal adder0_sum   : std_logic_vector(WIDTH+7 downto 0);
  signal adder0_carry : std_logic_vector(WIDTH+7 downto 0);

  signal adder1_sum   : std_logic_vector(WIDTH+7 downto 0);
  signal adder1_carry : std_logic_vector(WIDTH+7 downto 0);
  
  signal adder2_a     : std_logic_vector(WIDTH-1 downto 0);
  signal adder2_b     : std_logic_vector(WIDTH-1 downto 0);
  signal adder2_c     : std_logic_vector(WIDTH-1 downto 0);
  signal adder2_sum   : std_logic_vector(WIDTH-1 downto 0);
  signal adder2_carry : std_logic_vector(WIDTH-1 downto 0);
  signal adder2_cout  : std_logic;
  
  signal adder3_a     : std_logic_vector(WIDTH+7 downto 0);
  signal adder3_b     : std_logic_vector(WIDTH+7 downto 0);
  signal adder3_c     : std_logic_vector(WIDTH+7 downto 0);
  signal adder3_sum   : std_logic_vector(WIDTH+7 downto 0);
  signal adder3_carry : std_logic_vector(WIDTH+7 downto 0);
  
  signal adder4_a    : std_logic_vector(WIDTH+15 downto 0);
  signal adder4_b    : std_logic_vector(WIDTH+15 downto 0);
  signal adder4_sum  : std_logic_vector(WIDTH+15 downto 0);
  signal adder4_cin  : std_logic;
  
begin
  
  adder0: entity work.nacl_carry_save_adder_tree08
  generic map( 
    WIDTH => WIDTH
  )
  port map( 
    inp  => inp,
    en   => en0,
    cin  => '0',
    out0 => adder0_sum,
    out1 => adder0_carry
  );
  
  adder1: entity work.nacl_carry_save_adder_tree08
  generic map( 
    WIDTH => WIDTH
  )
  port map( 
    inp  => inp,
    en   => en1,
    cin  => '0',
    out0 => adder1_sum,
    out1 => adder1_carry
  );
  
  adder2 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH
  )
  port map( 
    a     => adder2_a,
    b     => adder2_b,
    c     => adder2_c,
    sum   => adder2_sum,
    carry => adder2_carry,
    cin   => '0',
    cout  => adder2_cout
  );
  
  adder3 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+8
  )
  port map( 
    a     => adder3_a,
    b     => adder3_b,
    c     => adder3_c,
    sum   => adder3_sum,
    carry => adder3_carry,
    cin   => '0'
  );
  
  adder4b : entity work.nacl_adder
  generic map( 
    WIDTH => WIDTH+16
  )
  port map( 
    a     => adder4_a,
    b     => adder4_b,
    sum   => adder4_sum,
    cin   => adder4_cin
  );
  
  en0 <= en(7 downto 0);
  en1 <= en(15 downto 8);
  
  adder2_a <= adder1_sum(WIDTH-1 downto 0);
  adder2_b <= adder0_sum(WIDTH+7 downto 8);
  adder2_c <= adder0_carry(WIDTH+7 downto 8);
  
  adder3_a <= adder1_carry;
  adder3_b <= adder1_sum(WIDTH+7 downto WIDTH) & adder2_sum(WIDTH-1 downto 0);
  adder3_c <= "0000000" & adder2_cout & adder2_carry;
  
  adder4_a   <= adder3_sum & adder0_sum(7 downto 0);
  adder4_b   <= adder3_carry & adder0_carry(7 downto 0);
  adder4_cin <= cin;
  
  sum  <= adder4_sum(WIDTH+14 downto 0);
  cout <= adder4_sum(WIDTH+15);
  
end;
