
------------------------------------------------------------------------------
---  THIS FILE WAS CREATED WITH THE PROGRAMMING TOOL  @  13.09.2015 17:23  ---
---  INPUTFILE: input\nacl_xz_fm08_vpvk_fi_dec.nacl                        ---
------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

package nacl_constants is

  function log2ceil (n : natural) return natural;
  function max (a, b : natural) return natural;

  ------------------------------------------------------------------------

  constant WORD_SIZE             : integer :=   32; -- DO NOT CHANGE !! 
  constant NUM_REGISTERS         : integer :=    9;
  constant MULT_CYCLES           : integer :=    8; -- must be in {2, 3, 4, 8, 16}
  constant NUM_CONSTANTS         : integer :=    6;
  constant ROTATE_VARIANTS       : integer :=   11; -- maximum 15
  constant CALL_TARGETS          : integer :=   16; -- maximum 16
  constant PROGRAM_SIZE          : integer := 1552;
  constant ADDRESS_PAGE_SIZE     : integer :=    2;
  constant ADDRESS_PAGES         : integer :=   32; -- maximum 64
  constant ACCU_EXTENSION        : integer :=    0; -- 32 when MULT_CYCLES=2, otherwise 0
  constant SKIP_CONSTANTS        : integer :=    2; -- maximum 4
  constant ADDER_CONSTANTS       : integer :=    4; -- maximum 4
  constant START_POINTS          : integer :=    7;
  constant START_POINT_CONSTANTS : integer :=    2;
  constant PUBLIC_ADDRESS_WIDTH  : integer :=    4; --should be 4
  constant PROGRAM_ROMS          : integer :=    2; -- 1 or 2
  constant LOOP_COUNTER_BITS     : integer :=    8; -- should be 8

  constant USE_MUL256            : integer := 1; -- 0 or 1
  constant USE_SELFTEST          : integer := 1; -- 0 or 1
  constant USE_CSA               : integer := 1; -- 0 or 1

  constant ACCU_SIZE            : integer := 2*WORD_SIZE+3;
  constant NUM_REGISTERS_LD     : integer := log2ceil(NUM_REGISTERS);
  constant RAM_SIZE             : integer := NUM_REGISTERS * 8;
  constant ROM_SIZE             : integer := NUM_CONSTANTS * 8;
  constant ADDRESSES            : integer := RAM_SIZE + ROM_SIZE;
  constant ADDRESS_WIDTH        : integer := log2ceil(ADDRESSES);
  constant ADDRESS_WIDTH_RAM    : integer := log2ceil(RAM_SIZE);
  constant ADDRESS_WIDTH_ROM    : integer := log2ceil(ROM_SIZE);
  constant MULT_CYCLES_LD       : integer := log2ceil(MULT_CYCLES);
  constant NUM_ADDERS           : integer := (WORD_SIZE + MULT_CYCLES - 1) / MULT_CYCLES - 1;
  constant ROTATE_VARIANTS_LD   : integer := log2ceil(ROTATE_VARIANTS+1);
  constant CALL_TARGETS_LD      : integer := log2ceil(CALL_TARGETS);
  constant PROGRAM_SIZE_LD      : integer := log2ceil(PROGRAM_SIZE);
  constant ADDRESS_PAGE_SIZE_LD : integer := log2ceil(ADDRESS_PAGE_SIZE);
  constant ADDRESS_PAGES_LD     : integer := log2ceil(ADDRESS_PAGES);
  constant BASE_ADDRESS_SIZE    : integer := ADDRESS_PAGE_SIZE_LD + ADDRESS_PAGES_LD;
  constant ADDER_CONSTANTS_LD   : integer := log2ceil(ADDER_CONSTANTS);
  constant SKIP_CONSTANTS_LD    : integer := log2ceil(SKIP_CONSTANTS);
  constant START_POINTS_LD      : integer := max(1, log2ceil(START_POINTS-1));

  ------------------------------------------------------------------------

  type call_target_rom_type is array(0 to max(1, CALL_TARGETS-1))
    of std_logic_vector (PROGRAM_SIZE_LD-1 downto 0);
  constant call_target_rom : call_target_rom_type := (
    "00001001110", -- MontgomeryLoop
    "01100101111", -- Mul256
    "01110110011", -- Add256
    "01111110000", -- Sub256
    "01011000110", -- Add_hc_low
    "01011011111", -- MulMod1305
    "01010101101", -- Add_hc_high
    "01110001110", -- Doubleround
    "01101101100", -- Init_r
    "00101011100", -- Update
    "00100110010", -- Salsa20
    "00100110111", -- Decrement
    "00110011111", -- Salsa20_u
    "00110100100", -- Decrement_u
    "01010100100", -- Full_tag_update
    "01001111011"  -- Update_with_R1
  );

  type skip_constant_rom_type is array(0 to max(1, SKIP_CONSTANTS-1))
    of std_logic_vector (LOOP_COUNTER_BITS-1 downto 0);
  constant skip_constant_rom : skip_constant_rom_type := (
    "00000000", -- 0
    "00001001"  -- 9
  );

  type alu_constants_rom is array(0 to max(1, NUM_CONSTANTS*8-1))
    of std_logic_vector(WORD_SIZE-1 downto 0);
  constant ALU_CONSTANTS : alu_constants_rom := (
    X"00000013", X"00000000", X"80000000", X"FFFFFFEC", X"FFFFFFFF", X"7FFFFFFF", X"00000000", X"00000000", -- R
    X"0001DB42", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", -- A24
    X"00000001", X"00000000", X"00000025", X"FFFFFFFF", X"00000026", X"80000000", X"40000000", X"00000007", -- LM
    X"61707865", X"3320646E", X"79622D32", X"6B206574", X"00000000", X"01000000", X"00000001", X"00000001", -- S
    X"F0000000", X"F0000003", X"F0000003", X"F0000003", X"FFFFFFFF", X"FFFFFFFF", X"FFFFFFFF", X"FFFFFFFF", -- M
    X"00000003", X"FFFFFFFC", X"00000000", X"00000005", X"FFFFFFFB", X"FFFFFFFF", X"00000000", X"00000000"  -- N
  );

  type rotate_distances_rom is array(0 to ROTATE_VARIANTS) of integer;
  constant ROTATE_DISTANCES : rotate_distances_rom := (
      0,                    --   0
    -32,                    -- -32 ... ROL32
        NUM_ADDERS+1,       --   8 ... MUL
     32-NUM_ADDERS-1,       --  24 ... WRSHR
    -32+NUM_ADDERS+1,       -- -24 ... MUL256, SUBACC, ROL24
       -NUM_ADDERS-1,       --  -8 ... ROL8
      2,                    --   2 ... ROR2
     30,                    --  30 ... ROR30
     -7,                    --  -7 ... ROL7
     -9,                    --  -9 ... ROL9
    -13,                    -- -13 ... ROL13
    -18                     -- -18 ... ROL18
  );

  type external_adder_settings_rom_type is array(0 to max(1, ADDER_CONSTANTS-1))
    of std_logic_vector(NUM_ADDERS downto 0);
  constant external_adder_settings_rom : external_adder_settings_rom_type := (
    "0001", -- C (USE_CARRY_IN_AS0)
    "0001", -- 1
    "0110", -- 6
    "0010"  -- 2
  );

  type controller_state_type is (S_WAIT, S_DO, S_MULT);

  ------------------------------------------------------------------------

  constant I_NOP        : std_logic_vector(3 downto 0) := "0000";
  constant I_ROL32      : std_logic_vector(3 downto 0) := "0001";
  constant I_LDC        : std_logic_vector(3 downto 0) := "0010";
  constant I_LD         : std_logic_vector(3 downto 0) := "0011";
  constant I_CLRL       : std_logic_vector(3 downto 0) := "0100";
  constant I_CLR        : std_logic_vector(3 downto 0) := "0101";
  constant I_CALC       : std_logic_vector(3 downto 0) := "0110";
     constant I_MULADD  : std_logic_vector(6 downto 0) := I_CALC & "000";     --inA      + inB[AS]
     constant I_MULSUB  : std_logic_vector(6 downto 0) := I_CALC & "100";     --inA      - inB[AS]
     constant I_MULADDC : std_logic_vector(6 downto 0) := I_CALC & "010";     --inA      + inB[AS] + c
     constant I_MULSUBC : std_logic_vector(6 downto 0) := I_CALC & "110";     --inA      - inB[AS] - c
     constant I_MULACC  : std_logic_vector(6 downto 0) := I_CALC & "001";     --accu     + inB[AS]
  constant I_COND      : std_logic_vector(3 downto 0) := "0111";
     constant I_JMP    : std_logic_vector(4 downto 0) := I_COND & '0';
     constant I_RET    : std_logic_vector(8 downto 0) := I_COND & "11111";   --RETURN
     constant I_SW0    : std_logic_vector(8 downto 0) := I_COND & "11000";   --SWAP when selected_bit = 0
     constant I_SW1    : std_logic_vector(8 downto 0) := I_COND & "11001";   --SWAP when selected_bit = 1
     constant I_SWLC   : std_logic_vector(8 downto 0) := I_COND & "11100";   --SWAP depending on V[LC-address]
     constant I_SLCI   : std_logic_vector(6 downto 0) := I_COND & "100";     --SKIP when LC = SC[i], INC LC anyway
     constant I_SLCD   : std_logic_vector(6 downto 0) := I_COND & "101";     --SKIP when LC = SC[i], DEC LC anyway
     constant I_INCLC  : std_logic_vector(8 downto 0) := I_COND & "11010";   --LC++
     constant I_DECLC  : std_logic_vector(8 downto 0) := I_COND & "11011";   --LC--
  constant I_ROT       : std_logic_vector(4 downto 0) := "10010";
     constant I_ROR2   : std_logic_vector(8 downto 0) := I_ROT & "0110";
     constant I_RORW   : std_logic_vector(8 downto 0) := I_ROT & "0010";
     constant I_ROR30  : std_logic_vector(8 downto 0) := I_ROT & "0111";
     constant I_ROL7   : std_logic_vector(8 downto 0) := I_ROT & "1000";
     constant I_ROLW   : std_logic_vector(8 downto 0) := I_ROT & "0101";
     constant I_ROL9   : std_logic_vector(8 downto 0) := I_ROT & "1001";
     constant I_ROL13  : std_logic_vector(8 downto 0) := I_ROT & "1010";
     constant I_ROL18  : std_logic_vector(8 downto 0) := I_ROT & "1011";
     constant I_RORIW  : std_logic_vector(8 downto 0) := I_ROT & "0011";
     constant I_ROLIW  : std_logic_vector(8 downto 0) := I_ROT & "0100";
  constant I_MULT      : std_logic_vector(4 downto 0) := "10011";
     constant I_MUL    : std_logic_vector(8 downto 0) := I_MULT & "0000";
     constant I_MUL256 : std_logic_vector(8 downto 0) := I_MULT & "0010";
  constant I_ST        : std_logic_vector(3 downto 0) := "1010";
  constant I_STR       : std_logic_vector(3 downto 0) := "1011";  --rotate in buffer and write into RAM
  constant I_MPS       : std_logic_vector(2 downto 0) := "110";
  constant I_FLC       : std_logic_vector(3 downto 0) := "1110";  --fetch V[LC-adress] (must be buffered in next cycle)
  constant I_EXTRA     : std_logic_vector(3 downto 0) := "1111";
     constant I_HLT    : std_logic_vector(8 downto 0) := I_EXTRA & "00000";
     constant I_STC    : std_logic_vector(8 downto 0) := I_EXTRA & "00001"; --save carry
     constant I_STI    : std_logic_vector(8 downto 0) := I_EXTRA & "00010"; --save carry inverted
     constant I_STX    : std_logic_vector(8 downto 0) := I_EXTRA & "00011"; --xor carry to previous carry
     constant I_AND    : std_logic_vector(8 downto 0) := I_EXTRA & "00100";
     constant I_OR     : std_logic_vector(8 downto 0) := I_EXTRA & "00101";
     constant I_EOR    : std_logic_vector(8 downto 0) := I_EXTRA & "00110";
     constant I_MPI    : std_logic_vector(8 downto 0) := I_EXTRA & "01000";
     constant I_MPD    : std_logic_vector(8 downto 0) := I_EXTRA & "01001";
     constant I_SFID   : std_logic_vector(7 downto 0) := I_EXTRA & "0111";  --skip when SP=sel_starting_point

  ------------------------------------------------------------------------

  type base_adress_rom_type is array(0 to ADDRESS_PAGE_SIZE*ADDRESS_PAGES*4-1)
    of std_logic_vector (ADDRESS_WIDTH-4 downto 0);
  constant base_adress_rom : base_adress_rom_type := (
    "0011", -- R3
    "0101", -- R5
    "0100", -- R4
    "1011", -- LM
    "0001", -- R1
    "0010", -- R2
    "0000", -- R0
    "1011", -- LM

    "0011", -- R3
    "0101", -- R5
    "----",
    "1000", -- R8
    "1011", -- LM
    "----",
    "0110", -- R6
    "1000", -- R8

    "0011", -- R3
    "0101", -- R5
    "----",
    "1000", -- R8
    "1011", -- LM
    "----",
    "0011", -- R3
    "1000", -- R8

    "0010", -- R2
    "0100", -- R4
    "1001", -- R
    "1000", -- R8
    "1011", -- LM
    "----",
    "0101", -- R5
    "1000", -- R8

    "0010", -- R2
    "0100", -- R4
    "----",
    "1000", -- R8
    "1011", -- LM
    "----",
    "0010", -- R2
    "1000", -- R8

    "0101", -- R5
    "0010", -- R2
    "----",
    "1000", -- R8
    "1011", -- LM
    "----",
    "0111", -- R7
    "1000", -- R8

    "0100", -- R4
    "0010", -- R2
    "----",
    "1000", -- R8
    "1011", -- LM
    "----",
    "0100", -- R4
    "1000", -- R8

    "0110", -- R6
    "0011", -- R3
    "----",
    "1000", -- R8
    "1011", -- LM
    "----",
    "0101", -- R5
    "1000", -- R8

    "0110", -- R6
    "0011", -- R3
    "----",
    "1000", -- R8
    "1011", -- LM
    "----",
    "0011", -- R3
    "1000", -- R8

    "0110", -- R6
    "0010", -- R2
    "1000", -- R8
    "0110", -- R6
    "0011", -- R3
    "0101", -- R5
    "1000", -- R8
    "0011", -- R3

    "0101", -- R5
    "0101", -- R5
    "1000", -- R8
    "0101", -- R5
    "0010", -- R2
    "0010", -- R2
    "1000", -- R8
    "0010", -- R2

    "0111", -- R7
    "1010", -- A24
    "1000", -- R8
    "0100", -- R4
    "0111", -- R7
    "0100", -- R4
    "1000", -- R8
    "0100", -- R4

    "0101", -- R5
    "0010", -- R2
    "1000", -- R8
    "0010", -- R2
    "0101", -- R5
    "0001", -- R1
    "1000", -- R8
    "0101", -- R5

    "0011", -- R3
    "0011", -- R3
    "1000", -- R8
    "0011", -- R3
    "0100", -- R4
    "0100", -- R4
    "1000", -- R8
    "0011", -- R3

    "0011", -- R3
    "0011", -- R3
    "1000", -- R8
    "0110", -- R6
    "0110", -- R6
    "0110", -- R6
    "1000", -- R8
    "0101", -- R5

    "0101", -- R5
    "0100", -- R4
    "1000", -- R8
    "0110", -- R6
    "0110", -- R6
    "0011", -- R3
    "1000", -- R8
    "0100", -- R4

    "0100", -- R4
    "0100", -- R4
    "1000", -- R8
    "0101", -- R5
    "0101", -- R5
    "0110", -- R6
    "1000", -- R8
    "0110", -- R6

    "0101", -- R5
    "0110", -- R6
    "1000", -- R8
    "0011", -- R3
    "0011", -- R3
    "0011", -- R3
    "1000", -- R8
    "0101", -- R5

    "0101", -- R5
    "0011", -- R3
    "1000", -- R8
    "0110", -- R6
    "0101", -- R5
    "0110", -- R6
    "1000", -- R8
    "0101", -- R5

    "0101", -- R5
    "0011", -- R3
    "1000", -- R8
    "0011", -- R3
    "0101", -- R5
    "0011", -- R3
    "1000", -- R8
    "0101", -- R5

    "0101", -- R5
    "0100", -- R4
    "1000", -- R8
    "0101", -- R5
    "0010", -- R2
    "0101", -- R5
    "1000", -- R8
    "0000", -- R0

    "0011", -- R3
    "0001", -- R1
    "1100", -- S
    "----",
    "0011", -- R3
    "1000", -- R8
    "1100", -- S
    "----",

    "0000", -- R0
    "0011", -- R3
    "1100", -- S
    "0001", -- R1
    "0010", -- R2
    "0110", -- R6
    "0100", -- R4
    "1100", -- S

    "0010", -- R2
    "0110", -- R6
    "0101", -- R5
    "1100", -- S
    "0100", -- R4
    "0101", -- R5
    "0010", -- R2
    "----",

    "0100", -- R4
    "0010", -- R2
    "0110", -- R6
    "1100", -- S
    "0101", -- R5
    "0010", -- R2
    "0110", -- R6
    "1100", -- S

    "0100", -- R4
    "0101", -- R5
    "0000", -- R0
    "0001", -- R1
    "0010", -- R2
    "0000", -- R0
    "----",
    "----",

    "0110", -- R6
    "0000", -- R0
    "0100", -- R4
    "1100", -- S
    "0110", -- R6
    "0000", -- R0
    "0101", -- R5
    "1100", -- S

    "0100", -- R4
    "0101", -- R5
    "0110", -- R6
    "----",
    "0100", -- R4
    "0101", -- R5
    "0111", -- R7
    "0001", -- R1

    "0010", -- R2
    "1100", -- S
    "----",
    "----",
    "0111", -- R7
    "1000", -- R8
    "1100", -- S
    "----",

    "0111", -- R7
    "1101", -- M
    "----",
    "----",
    "0011", -- R3
    "0000", -- R0
    "1100", -- S
    "----",

    "0111", -- R7
    "0011", -- R3
    "0100", -- R4
    "0101", -- R5
    "0100", -- R4
    "0101", -- R5
    "0011", -- R3
    "1110", -- N

    "0000", -- R0
    "0111", -- R7
    "----",
    "----",
    "----",
    "----",
    "----",
    "----"
  );

  type start_point_rom_type is array(0 to max(2, START_POINTS)-1) of std_logic_vector(PROGRAM_SIZE_LD downto 0);
  constant start_point_rom : start_point_rom_type := (
    '0' & "00000000000", -- Curve25519
    '0' & "00000000000", -- Curve25519
    '1' & "00011011101", -- Init
    '1' & "00011011011", -- Is_first_block
    '1' & "00101011100", -- Update
    '1' & "01010000010", -- Finalize
    '1' & "00000000000"  -- Decrypt
  );

  type start_point_constant_rom_type is array(0 to max(2, START_POINT_CONSTANTS)-1) of std_logic_vector(START_POINTS_LD-1 downto 0);
  constant start_point_constant_rom : start_point_constant_rom_type := (
    "001",
    "011" 
  );

  ------------------------------------------------------------------------
  constant TESTCASES        : integer := 7;
  constant TESTCASES_LD     : integer := log2ceil(TESTCASES);
  constant INPUT_VALUES     : integer := 2;
  constant INPUT_VALUES_LD  : integer := log2ceil(INPUT_VALUES*8);
  constant OUTPUT_VALUES    : integer := 2;
  constant OUTPUT_VALUES_LD : integer := log2ceil(OUTPUT_VALUES*8);
  constant COUNTER_WIDTH    : integer := max(log2ceil(INPUT_VALUES*8), log2ceil(OUTPUT_VALUES*8+1));

  type test_start_point_rom_type is array(0 to max(2, TESTCASES)-1) of std_logic_vector(START_POINTS_LD-1 downto 0);
  constant test_start_point_rom : test_start_point_rom_type := (
    "000",
    "001",
    "010",
    "011",
    "100",
    "100",
    "101"
  );

  type input_data_rom_type is array(0 to max(1, INPUT_VALUES*TESTCASES)*8-1) of std_logic_vector(WORD_SIZE-1 downto 0);
  constant input_data_rom : input_data_rom_type := (
    X"B3604D90", X"40D72456", X"227F0AB3", X"7CAEF27A", X"044E8E67", X"505F3CE1", X"B7E2AD9E", X"6277EA9A", -- R0
    X"1E78F40B", X"7624A155", X"E2B46692", X"D78935C7", X"63AF923F", X"77DAF319", X"7D4553F2", X"5750A078", -- R1
    X"B3604D90", X"40D72456", X"227F0AB3", X"7CAEF27A", X"044E8E67", X"505F3CE1", X"B7E2AD9E", X"6277EA9A", -- R0
    X"1E78F40B", X"7624A155", X"E2B46692", X"D78935C7", X"63AF923F", X"77DAF319", X"7D4553F2", X"5750A078", -- R1
    X"2DFB2DB0", X"536D0172", X"9D3BAFD2", X"4B3FA01C", X"4FC5BF1B", X"0D9B238F", X"00000000", X"00000000", -- R0
    X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", -- R1
    X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", -- R0
    X"C670405D", X"BB0FC2C3", X"1620EDAC", X"8401A73B", X"C665B9F1", X"6D607824", X"E1BEA6AD", X"A89993E2", -- R1
    X"E52B87C4", X"1FE06479", X"44AF88FC", X"EEABF113", X"E4D5A481", X"E4354F7D", X"A0292D64", X"06FC2AAB", -- R0
    X"C4BA4817", X"0C434130", X"949F6EF3", X"E291E7C7", X"C66FECB2", X"283083CD", X"03C763F5", X"B2B011C4", -- R1
    X"6BC849BF", X"09619FD1", X"0E9666F9", X"E8DCD13F", X"73DA58EC", X"C07B5DFA", X"154110CA", X"34DC9015", -- R0
    X"E0FB5325", X"9E62C745", X"B93C3976", X"88B3F763", X"F3BFB197", X"343B25EE", X"DB3EFC49", X"15A8EE86", -- R1
    X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", -- R0
    X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000"  -- R1
  );

  type input_address_rom_type is array(0 to max(2, INPUT_VALUES*TESTCASES)-1) of std_logic_vector(ADDRESS_WIDTH-4 downto 0);
  constant input_address_rom : input_address_rom_type := (
    "0000", -- R0
    "0001", -- R1
    "0000", -- R0
    "0001", -- R1
    "0000", -- R0
    "0001", -- R1
    "0000", -- R0
    "0001", -- R1
    "0000", -- R0
    "0001", -- R1
    "0000", -- R0
    "0001", -- R1
    "0000", -- R0
    "0001"  -- R1
  );

  type output_data_rom_type is array(0 to max(1, OUTPUT_VALUES*TESTCASES)*8) of std_logic_vector(WORD_SIZE-1 downto 0);
  constant output_data_rom : output_data_rom_type := (
    X"00000000", --FETCHING
    X"175B10F2", X"AFAE3A87", X"9238C87C", X"55E395EE", X"4ED352D3", X"D7D81058", X"581CD655", X"5FA5B4B5", -- R0
    X"1E78F40B", X"7624A155", X"E2B46692", X"D78935C7", X"63AF923F", X"77DAF319", X"7D4553F2", X"5750A078", -- R1
    X"175B10F2", X"AFAE3A87", X"9238C87C", X"55E395EE", X"4ED352D3", X"D7D81058", X"581CD655", X"5FA5B4B5", -- R2
    X"5FA5B4B5", X"581CD655", X"D7D81058", X"4ED352D3", X"55E395EE", X"9238C87C", X"AFAE3A87", X"175B10F2", -- R6
    X"2DFB2DB0", X"536D0172", X"9D3BAFD2", X"4B3FA01C", X"4FC5BF1B", X"0D9B238F", X"00000000", X"00000000", -- R0
    X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", -- R1
    X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", -- R0
    X"F868E203", X"110AEC6E", X"DB81BE54", X"CC415FA8", X"F9FC5657", X"56BB7F7C", X"B3896D42", X"D6B49D39", -- R1
    X"581C79F8", X"B09E6F2C", X"FC78A5F4", X"F1577FC8", X"EBD62524", X"59222859", X"68234348", X"D634A34B", -- R0
    X"3560D317", X"6DC7592D", X"F19F5E37", X"E9874712", X"A2F56A89", X"99EC431D", X"96BEE596", X"F22FBF7F", -- R1
    X"EF5C6D2F", X"68EA07AB", X"DE860A9C", X"763A3565", X"53F164CA", X"7A13AE5C", X"AEE7323F", X"CFD1B123", -- R0
    X"9EF332D0", X"38FE29FA", X"1BF0A583", X"89B88E7F", X"B9357DE3", X"302B2356", X"C4D4DC7E", X"9470DB5A", -- R1
    X"00000000", X"00000000", X"00000000", X"00000000", X"C2D94D00", X"A2B62333", X"2DB8D95C", X"824FD609", -- R0
    X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000", X"00000000"  -- R1
  );

  type output_address_rom_type is array(0 to max(2, OUTPUT_VALUES*TESTCASES)-1) of std_logic_vector(ADDRESS_WIDTH-4 downto 0);
  constant output_address_rom : output_address_rom_type := (
    "0000", -- R0
    "0001", -- R1
    "0010", -- R2
    "0110", -- R6
    "0000", -- R0
    "0001", -- R1
    "0000", -- R0
    "0001", -- R1
    "0000", -- R0
    "0001", -- R1
    "0000", -- R0
    "0001", -- R1
    "0000", -- R0
    "0001"  -- R1
  );

end;

package body nacl_constants is

  function log2ceil (n : natural) return natural is
    variable n_bit : unsigned(31 downto 0);
  begin
    if n = 0 then
      return 0;
    end if;
    n_bit := to_unsigned(n-1,32);
    for i in 31 downto 0 loop
      if n_bit(i) = '1' then
        return i+1;
      end if;
    end loop;
    return 1;
  end log2ceil;

  function max (a, b : natural) return natural is
  begin
    if a > b then
      return a;
    else
      return b;
    end if;
  end max;

end nacl_constants;

