
library ieee;       
use ieee.numeric_std.all;                                                  
use ieee.std_logic_1164.all;                                          
use ieee.std_logic_unsigned.all;  

use work.nacl_constants.all;

entity nacl_controller_memory_management_unit is 
  port(
    clk                 :  in std_logic;
    rst                 :  in std_logic;
    page_index_inc      :  in std_logic_vector(BASE_ADDRESS_SIZE-1 downto 0);
    page_index_param    :  in std_logic_vector(ADDRESS_PAGE_SIZE_LD+5 downto 0);
    page_index_en       :  in std_logic;
    page_index_sel      :  in std_logic;    
    address_index_param :  in std_logic_vector(4 downto 0);
    address_index_mult  :  in std_logic_vector(4 downto 0);
    address_index_sel   :  in std_logic_vector(1 downto 0);    
    loop_counter_en     :  in std_logic;
    loop_counter_inc    :  in std_logic_vector(LOOP_COUNTER_BITS-1 downto 0);
    loop_counter        : out std_logic_vector(LOOP_COUNTER_BITS-1 downto 0);
    sel_address_mux     :  in std_logic;
    ram_address         : out std_logic_vector(ADDRESS_WIDTH-1 downto 0)    
  );                               
end nacl_controller_memory_management_unit;                                                          

architecture behaviour of nacl_controller_memory_management_unit is  
    
  signal page_index_int       : std_logic_vector(BASE_ADDRESS_SIZE-1 downto 0);
  signal page_index_add       : std_logic_vector(BASE_ADDRESS_SIZE-1 downto 0);
  signal page_index_next      : std_logic_vector(BASE_ADDRESS_SIZE-1 downto 0);
  signal page_index           : std_logic_vector(BASE_ADDRESS_SIZE-1 downto 0);

  signal address_index_buffer : std_logic_vector(4 downto 0); 
  signal address_index        : std_logic_vector(4 downto 0); 

  signal loop_counter_int     : std_logic_vector(LOOP_COUNTER_BITS-1 downto 0); 
  signal loop_counter_add     : std_logic_vector(LOOP_COUNTER_BITS-1 downto 0);
  
begin
 
  pageIndexIncrement : entity work.nacl_adder
    generic map(
      WIDTH => BASE_ADDRESS_SIZE
    )
    port map(
      a    => page_index_int,
      b    => page_index_inc,
      sum  => page_index_add,
      cin  => '1',
      cout => open
    );
  
  pageIndexMux : entity work.nacl_mux2
    generic map( 
      WIDTH => BASE_ADDRESS_SIZE
    )
    port map(
      in0  => page_index_param(BASE_ADDRESS_SIZE-1 downto 0),
      in1  => page_index_add,
      outp => page_index_next,
      sel  => page_index_sel
    );
  
  pageIndex : entity work.nacl_register
    generic map( 
      WIDTH => BASE_ADDRESS_SIZE
    )
    port map(
      clk  => clk,
      en   => page_index_en,
      rst  => rst,
      din  => page_index_next,
      dout => page_index_int
    );
  page_index <= page_index_int;
  
  addressIndexMux : entity work.nacl_mux3
    generic map( 
      WIDTH => 5
    )
    port map(
      in0  => address_index_buffer,
      in1  => address_index_param,
      in2  => address_index_mult,
      outp => address_index,
      sel  => address_index_sel
    );  
  
  addressIndex : entity work.nacl_register
    generic map( 
      WIDTH => 5
    )
    port map(
      clk  => clk,
      en   => address_index_sel(0),
      rst  => rst,
      din  => address_index_param,
      dout => address_index_buffer
    );
   
  loopCounterIncrement : entity work.nacl_adder
    generic map(
       WIDTH => LOOP_COUNTER_BITS
     )
    port map(
      a    => loop_counter_int,
      b    => loop_counter_inc,
      sum  => loop_counter_add,
      cin  => '0',
      cout => open
     );
 
  loopCounter : entity work.nacl_register
    generic map( 
      WIDTH => LOOP_COUNTER_BITS
     )
    port map(
      clk  => clk,
      en   => loop_counter_en,
      rst  => rst,
      din  => loop_counter_add,
      dout => loop_counter_int
    );
  loop_counter <= loop_counter_int;
  
  wordIndexMux : entity work.nacl_mux2
    generic map( 
      WIDTH => 3
    )
    port map(
      in0  => address_index(2 downto 0),
      in1  => loop_counter_int(7 downto 5),
      outp => ram_address(2 downto 0),
      sel  => sel_address_mux
    );    
  ram_address(ADDRESS_WIDTH-1 downto 3) <= base_adress_rom(conv_integer(page_index & address_index(4 downto 3)));
  
end;
