
library ieee;       
use ieee.numeric_std.all;                                                  
use ieee.std_logic_1164.all;                                          
use ieee.std_logic_unsigned.all;  

use work.nacl_constants.all;

entity nacl_controller_program_counter is 
  port(
    clk                 :  in std_logic;
    rst                 :  in std_logic;
    call_stack_push     :  in std_logic;
    call_stack_pop      :  in std_logic;
    call_target_index   :  in std_logic_vector(CALL_TARGETS_LD-1 downto 0);    
    program_counter_rst :  in std_logic;
    program_counter_en  :  in std_logic;
    program_start       :  in std_logic_vector(PROGRAM_SIZE_LD-1 downto 0);  
    program_counter_inc :  in std_logic_vector(PROGRAM_SIZE_LD-1 downto 0);    
    program_counter     : out std_logic_vector(PROGRAM_SIZE_LD-1 downto 0)
  );                               
end nacl_controller_program_counter;                                                          

architecture behaviour of nacl_controller_program_counter is  
  
  signal program_counter_sel  : std_logic_vector(1 downto 0);
  signal program_counter_call : std_logic_vector(PROGRAM_SIZE_LD-1 downto 0);
  signal program_counter_add  : std_logic_vector(PROGRAM_SIZE_LD-1 downto 0);  
  signal program_counter_next : std_logic_vector(PROGRAM_SIZE_LD-1 downto 0);
  signal program_counter_ret  : std_logic_vector(PROGRAM_SIZE_LD-1 downto 0);  
  signal program_counter_int  : std_logic_vector(PROGRAM_SIZE_LD-1 downto 0); 
  
begin
     
  callAddressBuffer : entity work.nacl_register
    generic map( 
      WIDTH => PROGRAM_SIZE_LD-1
    )
    port map(
      clk  => clk,
      en   => call_stack_push,
      rst  => rst,
      din  => program_counter_int(PROGRAM_SIZE_LD-2 downto 0),
      dout => program_counter_ret(PROGRAM_SIZE_LD-2 downto 0)
    ); 
  program_counter_ret(PROGRAM_SIZE_LD-1) <= '0';

  programCounterIncrement : entity work.nacl_adder
    generic map(
      WIDTH => PROGRAM_SIZE_LD
    )
    port map(
      a    => program_counter_int,
      b    => program_counter_inc,
      sum  => program_counter_add,
      cin  => '0',
      cout => open
     );

  programCounterMux : entity work.nacl_mux3
    generic map( 
      WIDTH => PROGRAM_SIZE_LD
    )
    port map(
      in0  => program_counter_add,
      in1  => program_counter_call,
      in2  => program_counter_ret,
      outp => program_counter_next,
      sel  => program_counter_sel
    );
  program_counter_call <= call_target_rom(conv_integer(call_target_index));
  program_counter_sel  <= call_stack_pop & call_stack_push;

  programCounter : entity work.nacl_register_preset
    generic map( 
      WIDTH => PROGRAM_SIZE_LD
    )
    port map(
      clk       => clk,
      en        => program_counter_en,
      rst       => program_counter_rst,
      rst_value => program_start,
      din       => program_counter_next,
      dout      => program_counter_int
    );  
  program_counter <= program_counter_int;
 
end;
