
------------------------------------------------------------------------------
---  THIS FILE WAS CREATED WITH THE PROGRAMMING TOOL  @  17.10.2014 18:49  ---
---  INPUTFILE: input\testcase00_nacl_xz_cm02_vpvk_fi_dec.nacl             ---
------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

use work.nacl_constants.all;

entity nacl_controller_rom_program is
  port(
    program_counter :  in std_logic_vector(PROGRAM_SIZE_LD-1 downto 0);
    code            : out std_logic_vector(8 downto 0);
    sel_start_point :  in std_logic_vector(START_POINTS_LD-1 downto 0)
  );
end nacl_controller_rom_program;

architecture behaviour of nacl_controller_rom_program is

  type program_rom_type is array(0 to PROGRAM_SIZE-1) of std_logic_vector (8 downto 0);
  constant program_rom0 : program_rom_type := (

  -----------------------------------Curve25519

--  I_MPS    & "000000",
    I_MPS  & "000000",
    I_SW1,
    I_CLR    & "00" & "000",
    I_ST     & "00" & "001",
    I_ST     & "00" & "010",
    I_ST     & "00" & "011",
    I_ST     & "00" & "100",
    I_ST     & "00" & "101",
    I_ST     & "00" & "110",
    I_ST     & "00" & "111",
    I_ST     & "01" & "000",
    I_ST     & "01" & "001",
    I_ST     & "01" & "010",
    I_ST     & "01" & "011",
    I_ST     & "01" & "100",
    I_ST     & "01" & "101",
    I_ST     & "01" & "110",
    I_ST     & "01" & "111",
    I_ST     & "10" & "001",
    I_ST     & "10" & "010",
    I_ST     & "10" & "011",
    I_ST     & "10" & "100",
    I_ST     & "10" & "101",
    I_ST     & "10" & "110",
    I_ST     & "10" & "111",
    I_LDC    & "11" & "000",
    I_MULACC & "01",
    I_RORIW,
    I_ST     & "00" & "000",
    I_ST     & "10" & "000",
    I_MPS  & "000000",
    I_MPI,
    I_CLR    & "00" & "000",
    I_LD     & "00" & "000",
    I_MULACC & "01",
    I_STR    & "01" & "000",
    I_CLR    & "00" & "001",
    I_LD     & "00" & "001",
    I_MULACC & "01",
    I_STR    & "01" & "001",
    I_CLR    & "00" & "010",
    I_LD     & "00" & "010",
    I_MULACC & "01",
    I_STR    & "01" & "010",
    I_CLR    & "00" & "011",
    I_LD     & "00" & "011",
    I_MULACC & "01",
    I_STR    & "01" & "011",
    I_CLR    & "00" & "100",
    I_LD     & "00" & "100",
    I_MULACC & "01",
    I_STR    & "01" & "100",
    I_CLR    & "00" & "101",
    I_LD     & "00" & "101",
    I_MULACC & "01",
    I_STR    & "01" & "101",
    I_CLR    & "00" & "110",
    I_LD     & "00" & "110",
    I_MULACC & "01",
    I_STR    & "01" & "110",
    I_CLR    & "00" & "111",
    I_LD     & "00" & "111",
    I_MULACC & "01",
    I_STR    & "01" & "111",
    I_CLR    & "10" & "000",
    I_LD     & "11" & "111",
    I_AND,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "111",
    I_LD     & "11" & "101",
    I_AND,
    I_STR    & "10" & "111",
    I_CLR    & "10" & "111",
    I_LD     & "11" & "110",
    I_OR,
    I_STR    & "10" & "111",
    I_DECLC,
    I_DECLC,

  -----------------------------------MontgomeryLoop

    I_MPS  & "000000",
    I_MPI,
    I_FLC    & "10" & "000",
    I_LD     & "10" & "000",
    I_SWLC,
    I_MPS  & "000001",
    I_JMP    & "0010",
    I_MPS  & "000010",
    I_JMP    & "0011",
    I_MPS  & "000011",
    I_JMP    & "0010",
    I_MPS  & "000100",
    I_JMP    & "0011",
    I_MPS  & "001001",
    I_JMP    & "0001",
    I_MPS  & "001001",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "000101",
    I_JMP    & "0011",
    I_MPS  & "001011",
    I_JMP    & "0001",
    I_MPS  & "000110",
    I_JMP    & "0010",
    I_MPS  & "001011",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001100",
    I_JMP    & "0001",
    I_MPS  & "000111",
    I_JMP    & "0011",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001100",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001000",
    I_JMP    & "0010",
    I_MPS  & "001101",
    I_JMP    & "0001",
    I_SLCD   & "00",
    I_JMP    & "0000",
    I_INCLC,
    I_SW0,

  -----------------------------------Inversion

    I_MPS  & "001101",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001110",
    I_JMP    & "0001",
    I_MPS  & "001110",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001111",
    I_JMP    & "0001",
    I_MPS  & "001111",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "010000",
    I_JMP    & "0001",
    I_MPS  & "010000",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001110",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "010001",
    I_JMP    & "0001",
    I_MPS  & "010001",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "010010",
    I_JMP    & "0001",
    I_MPS  & "001110",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "010010",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "010011",
    I_JMP    & "0001",
    I_MPS  & "010001",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "010010",
    I_JMP    & "0001",
    I_MPS  & "001110",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "010010",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "010011",
    I_MPI,
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "001010",
    I_JMP    & "0001",
    I_MPS  & "010100",
    I_JMP    & "0001",

  -----------------------------------ProjectiveToAffineAndFreeze

    I_MPS  & "001100",
    I_JMP    & "0001",
    I_MPS  & "000011",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "000",
    I_MULADD & "01",
    I_RORIW,
    I_CLRL   & "10" & "001",
    I_LD     & "00" & "001",
    I_MULADDC& "01",
    I_RORIW,
    I_CLRL   & "10" & "001",
    I_LD     & "00" & "010",
    I_MULADDC& "01",
    I_RORIW,
    I_CLRL   & "10" & "001",
    I_LD     & "00" & "011",
    I_MULADDC& "01",
    I_RORIW,
    I_CLRL   & "10" & "001",
    I_LD     & "00" & "100",
    I_MULADDC& "01",
    I_RORIW,
    I_CLRL   & "10" & "001",
    I_LD     & "00" & "101",
    I_MULADDC& "01",
    I_RORIW,
    I_CLRL   & "10" & "001",
    I_LD     & "00" & "110",
    I_MULADDC& "01",
    I_RORIW,
    I_CLRL   & "10" & "010",
    I_LD     & "00" & "111",
    I_MULADDC& "01",
    I_RORIW,
    I_STC,
    I_CLR    & "10" & "011",
    I_LD     & "00" & "000",
    I_MULSUBC& "00",
    I_STR    & "00" & "000",
    I_CLRL   & "10" & "100",
    I_LD     & "00" & "001",
    I_MULSUBC& "00",
    I_STR    & "00" & "001",
    I_CLRL   & "10" & "100",
    I_LD     & "00" & "010",
    I_MULSUBC& "00",
    I_STR    & "00" & "010",
    I_CLRL   & "10" & "100",
    I_LD     & "00" & "011",
    I_MULSUBC& "00",
    I_STR    & "00" & "011",
    I_CLRL   & "10" & "100",
    I_LD     & "00" & "100",
    I_MULSUBC& "00",
    I_STR    & "00" & "100",
    I_CLRL   & "10" & "100",
    I_LD     & "00" & "101",
    I_MULSUBC& "00",
    I_STR    & "00" & "101",
    I_CLRL   & "10" & "100",
    I_LD     & "00" & "110",
    I_MULSUBC& "00",
    I_STR    & "00" & "110",
    I_CLRL   & "10" & "101",
    I_LD     & "00" & "111",
    I_MULSUBC& "00",
    I_STR    & "00" & "111",

  -----------------------------------PublicKey

    I_MPS  & "010100",
    I_MPI,
    I_CLR    & "00" & "000",
    I_LD     & "00" & "000",
    I_MULACC & "01",
    I_SFID   & "0",
    I_STR    & "11" & "000",
    I_CLR    & "00" & "001",
    I_LD     & "00" & "001",
    I_MULACC & "01",
    I_SFID   & "0",
    I_STR    & "11" & "001",
    I_CLR    & "00" & "010",
    I_LD     & "00" & "010",
    I_MULACC & "01",
    I_SFID   & "0",
    I_STR    & "11" & "010",
    I_CLR    & "00" & "011",
    I_LD     & "00" & "011",
    I_MULACC & "01",
    I_SFID   & "0",
    I_STR    & "11" & "011",
    I_CLR    & "00" & "100",
    I_LD     & "00" & "100",
    I_MULACC & "01",
    I_SFID   & "0",
    I_STR    & "11" & "100",
    I_CLR    & "00" & "101",
    I_LD     & "00" & "101",
    I_MULACC & "01",
    I_SFID   & "0",
    I_STR    & "11" & "101",
    I_CLR    & "00" & "110",
    I_LD     & "00" & "110",
    I_MULACC & "01",
    I_SFID   & "0",
    I_STR    & "11" & "110",
    I_CLR    & "00" & "111",
    I_LD     & "00" & "111",
    I_MULACC & "01",
    I_SFID   & "0",
    I_STR    & "11" & "111",
    I_SFID   & "0",
    I_HLT,

  -----------------------------------PrivateKey

    I_MPS  & "001001",
    I_CLR    & "01" & "000",
    I_LD     & "01" & "000",
    I_MULACC & "01",
    I_STR    & "00" & "111",
    I_CLR    & "01" & "001",
    I_LD     & "01" & "001",
    I_MULACC & "01",
    I_STR    & "00" & "110",
    I_CLR    & "01" & "010",
    I_LD     & "01" & "010",
    I_MULACC & "01",
    I_STR    & "00" & "101",
    I_CLR    & "01" & "011",
    I_LD     & "01" & "011",
    I_MULACC & "01",
    I_STR    & "00" & "100",
    I_CLR    & "01" & "100",
    I_LD     & "01" & "100",
    I_MULACC & "01",
    I_STR    & "00" & "011",
    I_CLR    & "01" & "101",
    I_LD     & "01" & "101",
    I_MULACC & "01",
    I_STR    & "00" & "010",
    I_CLR    & "01" & "110",
    I_LD     & "01" & "110",
    I_MULACC & "01",
    I_STR    & "00" & "001",
    I_CLR    & "01" & "111",
    I_LD     & "01" & "111",
    I_MULACC & "01",
    I_STR    & "00" & "000",
    I_HLT,

  -----------------------------------Mul256

    I_CLR    & "00" & "000",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "000",
    I_CLRL   & "00" & "000",
    I_LD     & "01" & "001",
    I_MUL,
    I_ROL32  & "00" & "001",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "001",
    I_CLRL   & "00" & "000",
    I_LD     & "01" & "010",
    I_MUL,
    I_ROL32  & "00" & "001",
    I_LD     & "01" & "001",
    I_MUL,
    I_ROL32  & "00" & "010",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "010",
    I_CLRL   & "00" & "000",
    I_LD     & "01" & "011",
    I_MUL,
    I_ROL32  & "00" & "001",
    I_LD     & "01" & "010",
    I_MUL,
    I_ROL32  & "00" & "010",
    I_LD     & "01" & "001",
    I_MUL,
    I_ROL32  & "00" & "011",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "011",
    I_CLRL   & "00" & "000",
    I_LD     & "01" & "100",
    I_MUL,
    I_ROL32  & "00" & "001",
    I_LD     & "01" & "011",
    I_MUL,
    I_ROL32  & "00" & "010",
    I_LD     & "01" & "010",
    I_MUL,
    I_ROL32  & "00" & "011",
    I_LD     & "01" & "001",
    I_MUL,
    I_ROL32  & "00" & "100",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "100",
    I_CLRL   & "00" & "000",
    I_LD     & "01" & "101",
    I_MUL,
    I_ROL32  & "00" & "001",
    I_LD     & "01" & "100",
    I_MUL,
    I_ROL32  & "00" & "010",
    I_LD     & "01" & "011",
    I_MUL,
    I_ROL32  & "00" & "011",
    I_LD     & "01" & "010",
    I_MUL,
    I_ROL32  & "00" & "100",
    I_LD     & "01" & "001",
    I_MUL,
    I_ROL32  & "00" & "101",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "101",
    I_CLRL   & "00" & "000",
    I_LD     & "01" & "110",
    I_MUL,
    I_ROL32  & "00" & "001",
    I_LD     & "01" & "101",
    I_MUL,
    I_ROL32  & "00" & "010",
    I_LD     & "01" & "100",
    I_MUL,
    I_ROL32  & "00" & "011",
    I_LD     & "01" & "011",
    I_MUL,
    I_ROL32  & "00" & "100",
    I_LD     & "01" & "010",
    I_MUL,
    I_ROL32  & "00" & "101",
    I_LD     & "01" & "001",
    I_MUL,
    I_ROL32  & "00" & "110",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "110",
    I_CLRL   & "00" & "000",
    I_LD     & "01" & "111",
    I_MUL,
    I_ROL32  & "00" & "001",
    I_LD     & "01" & "110",
    I_MUL,
    I_ROL32  & "00" & "010",
    I_LD     & "01" & "101",
    I_MUL,
    I_ROL32  & "00" & "011",
    I_LD     & "01" & "100",
    I_MUL,
    I_ROL32  & "00" & "100",
    I_LD     & "01" & "011",
    I_MUL,
    I_ROL32  & "00" & "101",
    I_LD     & "01" & "010",
    I_MUL,
    I_ROL32  & "00" & "110",
    I_LD     & "01" & "001",
    I_MUL,
    I_ROL32  & "00" & "111",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "111",
    I_CLRL   & "00" & "001",
    I_LD     & "01" & "111",
    I_MUL,
    I_ROL32  & "00" & "010",
    I_LD     & "01" & "110",
    I_MUL,
    I_ROL32  & "00" & "011",
    I_LD     & "01" & "101",
    I_MUL,
    I_ROL32  & "00" & "100",
    I_LD     & "01" & "100",
    I_MUL,
    I_ROL32  & "00" & "101",
    I_LD     & "01" & "011",
    I_MUL,
    I_ROL32  & "00" & "110",
    I_LD     & "01" & "010",
    I_MUL,
    I_ROL32  & "00" & "111",
    I_LD     & "01" & "001",
    I_MUL,
    I_ST     & "11" & "000",
    I_CLRL   & "00" & "010",
    I_LD     & "01" & "111",
    I_MUL,
    I_ROL32  & "00" & "011",
    I_LD     & "01" & "110",
    I_MUL,
    I_ROL32  & "00" & "100",
    I_LD     & "01" & "101",
    I_MUL,
    I_ROL32  & "00" & "101",
    I_LD     & "01" & "100",
    I_MUL,
    I_ROL32  & "00" & "110",
    I_LD     & "01" & "011",
    I_MUL,
    I_ROL32  & "00" & "111",
    I_LD     & "01" & "010",
    I_MUL,
    I_ST     & "11" & "001",
    I_CLRL   & "00" & "011",
    I_LD     & "01" & "111",
    I_MUL,
    I_ROL32  & "00" & "100",
    I_LD     & "01" & "110",
    I_MUL,
    I_ROL32  & "00" & "101",
    I_LD     & "01" & "101",
    I_MUL,
    I_ROL32  & "00" & "110",
    I_LD     & "01" & "100",
    I_MUL,
    I_ROL32  & "00" & "111",
    I_LD     & "01" & "011",
    I_MUL,
    I_ST     & "11" & "010",
    I_CLRL   & "00" & "100",
    I_LD     & "01" & "111",
    I_MUL,
    I_ROL32  & "00" & "101",
    I_LD     & "01" & "110",
    I_MUL,
    I_ROL32  & "00" & "110",
    I_LD     & "01" & "101",
    I_MUL,
    I_ROL32  & "00" & "111",
    I_LD     & "01" & "100",
    I_MUL,
    I_ST     & "11" & "011",
    I_CLRL   & "00" & "101",
    I_LD     & "01" & "111",
    I_MUL,
    I_ROL32  & "00" & "110",
    I_LD     & "01" & "110",
    I_MUL,
    I_ROL32  & "00" & "111",
    I_LD     & "01" & "101",
    I_MUL,
    I_ST     & "11" & "100",
    I_CLRL   & "00" & "110",
    I_LD     & "01" & "111",
    I_MUL,
    I_ROL32  & "00" & "111",
    I_LD     & "01" & "110",
    I_MUL,
    I_ST     & "11" & "101",
    I_CLRL   & "00" & "111",
    I_LD     & "01" & "111",
    I_MUL,
    I_ST     & "11" & "110",
    I_RORIW,
    I_RORW,
    I_ST     & "11" & "111",
    I_CLR    & "11" & "000",
    I_LD     & "10" & "000",
    I_MULADD & "10",
    I_STR    & "11" & "000",
    I_CLRL   & "11" & "001",
    I_RORW,
    I_LD     & "10" & "001",
    I_MULACC & "10",
    I_LD     & "10" & "001",
    I_MULACC & "01",
    I_STR    & "11" & "001",
    I_CLRL   & "11" & "010",
    I_RORW,
    I_LD     & "10" & "010",
    I_MULACC & "10",
    I_LD     & "10" & "010",
    I_MULACC & "01",
    I_STR    & "11" & "010",
    I_CLRL   & "11" & "011",
    I_RORW,
    I_LD     & "10" & "011",
    I_MULACC & "10",
    I_LD     & "10" & "011",
    I_MULACC & "01",
    I_STR    & "11" & "011",
    I_CLRL   & "11" & "100",
    I_RORW,
    I_LD     & "10" & "100",
    I_MULACC & "10",
    I_LD     & "10" & "100",
    I_MULACC & "01",
    I_STR    & "11" & "100",
    I_CLRL   & "11" & "101",
    I_RORW,
    I_LD     & "10" & "101",
    I_MULACC & "10",
    I_LD     & "10" & "101",
    I_MULACC & "01",
    I_STR    & "11" & "101",
    I_CLRL   & "11" & "110",
    I_RORW,
    I_LD     & "10" & "110",
    I_MULACC & "10",
    I_LD     & "10" & "110",
    I_MULACC & "01",
    I_STR    & "11" & "110",
    I_CLRL   & "11" & "111",
    I_RORW,
    I_LD     & "10" & "111",
    I_MULACC & "10",
    I_LD     & "10" & "111",
    I_MULACC & "01",
    I_STR    & "11" & "111",
    I_RORW,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "11" & "000",
    I_MULADD & "10",
    I_STR    & "11" & "000",
    I_CLRL   & "11" & "001",
    I_RORW,
    I_LD     & "11" & "001",
    I_MULACC & "01",
    I_STR    & "11" & "001",
    I_CLRL   & "11" & "010",
    I_RORW,
    I_LD     & "11" & "010",
    I_MULACC & "01",
    I_STR    & "11" & "010",
    I_CLRL   & "11" & "011",
    I_RORW,
    I_LD     & "11" & "011",
    I_MULACC & "01",
    I_STR    & "11" & "011",
    I_CLRL   & "11" & "100",
    I_RORW,
    I_LD     & "11" & "100",
    I_MULACC & "01",
    I_STR    & "11" & "100",
    I_CLRL   & "11" & "101",
    I_RORW,
    I_LD     & "11" & "101",
    I_MULACC & "01",
    I_STR    & "11" & "101",
    I_CLRL   & "11" & "110",
    I_RORW,
    I_LD     & "11" & "110",
    I_MULACC & "01",
    I_STR    & "11" & "110",
    I_CLRL   & "11" & "111",
    I_RORW,
    I_LD     & "11" & "111",
    I_MULACC & "01",
    I_STR    & "11" & "111",
    I_RORW,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "11" & "000",
    I_MULADD & "10",
    I_STR    & "11" & "000",
    I_RET,

  -----------------------------------Add256

    I_CLR    & "00" & "000",
    I_LD     & "01" & "000",
    I_MULADD & "01",
    I_STR    & "11" & "000",
    I_CLRL   & "00" & "001",
    I_LD     & "01" & "001",
    I_MULADDC& "01",
    I_STR    & "11" & "001",
    I_CLRL   & "00" & "010",
    I_LD     & "01" & "010",
    I_MULADDC& "01",
    I_STR    & "11" & "010",
    I_CLRL   & "00" & "011",
    I_LD     & "01" & "011",
    I_MULADDC& "01",
    I_STR    & "11" & "011",
    I_CLRL   & "00" & "100",
    I_LD     & "01" & "100",
    I_MULADDC& "01",
    I_STR    & "11" & "100",
    I_CLRL   & "00" & "101",
    I_LD     & "01" & "101",
    I_MULADDC& "01",
    I_STR    & "11" & "101",
    I_CLRL   & "00" & "110",
    I_LD     & "01" & "110",
    I_MULADDC& "01",
    I_STR    & "11" & "110",
    I_CLRL   & "00" & "111",
    I_LD     & "01" & "111",
    I_MULADDC& "01",
    I_STR    & "11" & "111",
    I_MPI,
    I_STC,
    I_CLR    & "00" & "100",
    I_LD     & "11" & "000",
    I_MULADD & "00",
    I_STR    & "10" & "000",
    I_CLRL   & "00" & "001",
    I_LD     & "11" & "001",
    I_MULADDC& "01",
    I_STR    & "10" & "001",
    I_CLRL   & "11" & "010",
    I_MULADDC& "01",
    I_STR    & "10" & "010",
    I_CLRL   & "11" & "011",
    I_MULADDC& "01",
    I_STR    & "10" & "011",
    I_CLRL   & "11" & "100",
    I_MULADDC& "01",
    I_STR    & "10" & "100",
    I_CLRL   & "11" & "101",
    I_MULADDC& "01",
    I_STR    & "10" & "101",
    I_CLRL   & "11" & "110",
    I_MULADDC& "01",
    I_STR    & "10" & "110",
    I_CLRL   & "11" & "111",
    I_MULADDC& "01",
    I_STR    & "10" & "111",
    I_RET,

  -----------------------------------Sub256

    I_CLR    & "01" & "000",
    I_LD     & "00" & "000",
    I_MULSUB & "01",
    I_STR    & "11" & "000",
    I_CLRL   & "01" & "001",
    I_LD     & "00" & "001",
    I_MULSUBC& "01",
    I_STR    & "11" & "001",
    I_CLRL   & "01" & "010",
    I_LD     & "00" & "010",
    I_MULSUBC& "01",
    I_STR    & "11" & "010",
    I_CLRL   & "01" & "011",
    I_LD     & "00" & "011",
    I_MULSUBC& "01",
    I_STR    & "11" & "011",
    I_CLRL   & "01" & "100",
    I_LD     & "00" & "100",
    I_MULSUBC& "01",
    I_STR    & "11" & "100",
    I_CLRL   & "01" & "101",
    I_LD     & "00" & "101",
    I_MULSUBC& "01",
    I_STR    & "11" & "101",
    I_CLRL   & "01" & "110",
    I_LD     & "00" & "110",
    I_MULSUBC& "01",
    I_STR    & "11" & "110",
    I_CLRL   & "01" & "111",
    I_LD     & "00" & "111",
    I_MULSUBC& "01",
    I_STR    & "11" & "111",
    I_MPI,
    I_STI,
    I_CLR    & "00" & "010",
    I_LD     & "11" & "000",
    I_MULSUBC& "00",
    I_STR    & "10" & "000",
    I_CLRL   & "00" & "001",
    I_LD     & "11" & "001",
    I_MULSUBC& "00",
    I_STR    & "10" & "001",
    I_CLRL   & "11" & "010",
    I_MULSUBC& "00",
    I_STR    & "10" & "010",
    I_CLRL   & "11" & "011",
    I_MULSUBC& "00",
    I_STR    & "10" & "011",
    I_CLRL   & "11" & "100",
    I_MULSUBC& "00",
    I_STR    & "10" & "100",
    I_CLRL   & "11" & "101",
    I_MULSUBC& "00",
    I_STR    & "10" & "101",
    I_CLRL   & "11" & "110",
    I_MULSUBC& "00",
    I_STR    & "10" & "110",
    I_CLRL   & "11" & "111",
    I_MULSUBC& "00",
    I_STR    & "10" & "111",
    I_STX,
    I_CLR    & "00" & "010",
    I_LD     & "10" & "000",
    I_MULSUBC& "00",
    I_STR    & "10" & "000",
    I_RET,

  -----------------------------------padding0

    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
    I_NOP    & "00" & "000",
---------------------------------------------------------
    I_NOP    & "00000"
  );

  constant program_rom1 : program_rom_type := (

  -----------------------------------Decrypt

    I_MPS  & "000000",
    I_CLR    & "00" & "000",
    I_ST     & "00" & "000",
    I_ST     & "00" & "001",
    I_ST     & "00" & "010",
    I_ST     & "00" & "011",
    I_ST     & "00" & "100",
    I_ST     & "00" & "101",
    I_ST     & "00" & "110",
    I_ST     & "00" & "111",
    I_MPS  & "010101",
    I_JMP    & "0100",
    I_JMP    & "0101",
    I_MPS  & "010101",
    I_JMP    & "0110",
    I_JMP    & "0101",
    I_MPS  & "010101",
    I_MPI,
    I_JMP    & "0100",
    I_MPS  & "010110",
    I_CLR    & "00" & "000",
    I_LD     & "01" & "000",
    I_MULSUBC& "00",
    I_STR    & "00" & "000",
    I_CLRL   & "00" & "001",
    I_LD     & "01" & "001",
    I_MULSUBC& "00",
    I_STR    & "00" & "001",
    I_CLRL   & "00" & "010",
    I_LD     & "01" & "010",
    I_MULSUBC& "00",
    I_STR    & "00" & "010",
    I_CLRL   & "00" & "011",
    I_LD     & "01" & "011",
    I_MULSUBC& "00",
    I_STR    & "00" & "011",
    I_CLRL   & "00" & "100",
    I_LD     & "01" & "100",
    I_MULSUBC& "00",
    I_STR    & "00" & "100",
    I_CLRL   & "00" & "101",
    I_LD     & "01" & "101",
    I_MULSUBC& "00",
    I_STR    & "00" & "101",
    I_CLRL   & "00" & "110",
    I_LD     & "01" & "110",
    I_MULSUBC& "00",
    I_STR    & "00" & "110",
    I_CLRL   & "00" & "111",
    I_LD     & "01" & "111",
    I_MULSUBC& "00",
    I_STR    & "00" & "111",
    I_MPS  & "010110",
    I_MPI,
    I_CLR    & "11" & "000",
    I_LD     & "11" & "000",
    I_MULACC & "01",
    I_STR    & "10" & "000",
    I_CLR    & "01" & "000",
    I_LD     & "01" & "000",
    I_MULACC & "01",
    I_STR    & "10" & "001",
    I_CLR    & "01" & "001",
    I_LD     & "01" & "001",
    I_MULACC & "01",
    I_STR    & "10" & "010",
    I_CLR    & "01" & "010",
    I_LD     & "01" & "010",
    I_MULACC & "01",
    I_STR    & "10" & "011",
    I_CLR    & "01" & "011",
    I_LD     & "01" & "011",
    I_MULACC & "01",
    I_STR    & "10" & "100",
    I_CLR    & "11" & "001",
    I_LD     & "11" & "001",
    I_MULACC & "01",
    I_STR    & "10" & "101",
    I_CLR    & "00" & "010",
    I_LD     & "00" & "010",
    I_MULACC & "01",
    I_STR    & "10" & "110",
    I_CLR    & "00" & "011",
    I_LD     & "00" & "011",
    I_MULACC & "01",
    I_STR    & "10" & "111",
    I_MPS  & "010111",
    I_CLR    & "10" & "111",
    I_ST     & "10" & "000",
    I_ST     & "10" & "001",
    I_CLR    & "11" & "010",
    I_LD     & "11" & "010",
    I_MULACC & "01",
    I_STR    & "10" & "010",
    I_CLR    & "01" & "100",
    I_LD     & "01" & "100",
    I_MULACC & "01",
    I_STR    & "10" & "011",
    I_CLR    & "01" & "101",
    I_LD     & "01" & "101",
    I_MULACC & "01",
    I_STR    & "10" & "100",
    I_CLR    & "01" & "110",
    I_LD     & "01" & "110",
    I_MULACC & "01",
    I_STR    & "10" & "101",
    I_CLR    & "01" & "111",
    I_LD     & "01" & "111",
    I_MULACC & "01",
    I_STR    & "10" & "110",
    I_CLR    & "11" & "011",
    I_LD     & "11" & "011",
    I_MULACC & "01",
    I_STR    & "10" & "111",
    I_MPS  & "010111",
    I_MPI,
    I_JMP    & "0111",
    I_JMP    & "0111",
    I_JMP    & "0111",
    I_JMP    & "0111",
    I_JMP    & "0111",
    I_JMP    & "0111",
    I_JMP    & "0111",
    I_JMP    & "0111",
    I_JMP    & "0111",
    I_JMP    & "0111",
    I_MPS  & "011000",
    I_CLR    & "00" & "000",
    I_LD     & "11" & "000",
    I_MULADD & "01",
    I_STR    & "00" & "000",
    I_CLR    & "00" & "001",
    I_LD     & "10" & "000",
    I_MULADD & "01",
    I_STR    & "00" & "001",
    I_CLR    & "00" & "010",
    I_LD     & "10" & "001",
    I_MULADD & "01",
    I_STR    & "00" & "010",
    I_CLR    & "00" & "011",
    I_LD     & "10" & "010",
    I_MULADD & "01",
    I_STR    & "00" & "011",
    I_CLR    & "00" & "100",
    I_LD     & "10" & "011",
    I_MULADD & "01",
    I_STR    & "00" & "100",
    I_CLR    & "00" & "101",
    I_LD     & "11" & "001",
    I_MULADD & "01",
    I_STR    & "00" & "101",
    I_CLR    & "00" & "110",
    I_LD     & "01" & "010",
    I_MULADD & "01",
    I_STR    & "00" & "110",
    I_CLR    & "00" & "111",
    I_LD     & "01" & "011",
    I_MULADD & "01",
    I_STR    & "00" & "111",
    I_MPS  & "011000",
    I_MPI,
    I_CLR    & "00" & "010",
    I_LD     & "11" & "010",
    I_MULADD & "01",
    I_STR    & "00" & "010",
    I_CLR    & "00" & "011",
    I_LD     & "10" & "100",
    I_MULADD & "01",
    I_STR    & "00" & "011",
    I_CLR    & "00" & "100",
    I_LD     & "10" & "101",
    I_MULADD & "01",
    I_STR    & "00" & "100",
    I_CLR    & "00" & "101",
    I_LD     & "10" & "110",
    I_MULADD & "01",
    I_STR    & "00" & "101",
    I_CLR    & "00" & "110",
    I_LD     & "10" & "111",
    I_MULADD & "01",
    I_STR    & "00" & "110",
    I_CLR    & "00" & "111",
    I_LD     & "11" & "011",
    I_MULADD & "01",
    I_STR    & "00" & "111",
    I_MPS  & "011001",
    I_CLR    & "01" & "000",
    I_LD     & "11" & "000",
    I_EOR,
    I_STR    & "11" & "000",
    I_CLR    & "01" & "001",
    I_LD     & "11" & "001",
    I_EOR,
    I_STR    & "11" & "001",
    I_CLR    & "01" & "010",
    I_LD     & "11" & "010",
    I_EOR,
    I_STR    & "11" & "010",
    I_CLR    & "01" & "011",
    I_LD     & "11" & "011",
    I_EOR,
    I_STR    & "11" & "011",
    I_CLR    & "01" & "100",
    I_LD     & "11" & "100",
    I_EOR,
    I_STR    & "11" & "100",
    I_CLR    & "01" & "101",
    I_LD     & "11" & "101",
    I_EOR,
    I_STR    & "11" & "101",
    I_CLR    & "01" & "110",
    I_LD     & "11" & "110",
    I_EOR,
    I_STR    & "11" & "110",
    I_CLR    & "01" & "111",
    I_LD     & "11" & "111",
    I_EOR,
    I_STR    & "11" & "111",
    I_HLT,

  -----------------------------------Is_first_block

    I_JMP    & "1000",
    I_JMP    & "1001",

  -----------------------------------Init

    I_MPS  & "011001",
    I_MPI,
    I_CLR    & "01" & "100",
    I_LD     & "01" & "100",
    I_MULACC & "01",
    I_STR    & "00" & "010",
    I_CLR    & "01" & "101",
    I_LD     & "01" & "101",
    I_MULACC & "01",
    I_STR    & "00" & "011",
    I_CLR    & "01" & "110",
    I_LD     & "01" & "110",
    I_MULACC & "01",
    I_STR    & "00" & "100",
    I_CLR    & "01" & "111",
    I_LD     & "01" & "111",
    I_MULACC & "01",
    I_STR    & "00" & "101",
    I_MPS  & "011010",
    I_CLR    & "11" & "000",
    I_LD     & "11" & "000",
    I_MULACC & "01",
    I_STR    & "10" & "000",
    I_CLR    & "00" & "000",
    I_LD     & "00" & "000",
    I_MULACC & "01",
    I_STR    & "10" & "001",
    I_CLR    & "00" & "001",
    I_LD     & "00" & "001",
    I_MULACC & "01",
    I_STR    & "10" & "010",
    I_CLR    & "00" & "010",
    I_LD     & "00" & "010",
    I_MULACC & "01",
    I_STR    & "10" & "011",
    I_CLR    & "00" & "011",
    I_LD     & "00" & "011",
    I_MULACC & "01",
    I_STR    & "10" & "100",
    I_CLR    & "11" & "001",
    I_LD     & "11" & "001",
    I_MULACC & "01",
    I_STR    & "10" & "101",
    I_CLR    & "01" & "000",
    I_LD     & "01" & "000",
    I_MULACC & "01",
    I_STR    & "10" & "110",
    I_CLR    & "01" & "001",
    I_LD     & "01" & "001",
    I_MULACC & "01",
    I_STR    & "10" & "111",
    I_MPS  & "011010",
    I_MPI,
    I_CLR    & "01" & "010",
    I_LD     & "01" & "010",
    I_MULACC & "01",
    I_STR    & "10" & "000",
    I_CLR    & "01" & "011",
    I_LD     & "01" & "011",
    I_MULACC & "01",
    I_STR    & "10" & "001",
    I_CLR    & "11" & "010",
    I_LD     & "11" & "010",
    I_MULACC & "01",
    I_STR    & "10" & "010",
    I_CLR    & "00" & "100",
    I_LD     & "00" & "100",
    I_MULACC & "01",
    I_STR    & "10" & "011",
    I_CLR    & "00" & "101",
    I_LD     & "00" & "101",
    I_MULACC & "01",
    I_STR    & "10" & "100",
    I_CLR    & "00" & "110",
    I_LD     & "00" & "110",
    I_MULACC & "01",
    I_STR    & "10" & "101",
    I_CLR    & "00" & "111",
    I_LD     & "00" & "111",
    I_MULACC & "01",
    I_STR    & "10" & "110",
    I_CLR    & "11" & "011",
    I_LD     & "11" & "011",
    I_MULACC & "01",
    I_STR    & "10" & "111",

  -----------------------------------Salsa20

    I_MPS  & "010111",
    I_MPI,
    I_JMP    & "0111",
    I_SLCI   & "01",
    I_JMP    & "1010",

  -----------------------------------Decrement

    I_SLCD   & "00",
    I_JMP    & "1011",
    I_INCLC,
    I_MPS  & "011011",
    I_CLR    & "00" & "000",
    I_LD     & "00" & "000",
    I_MULACC & "01",
    I_STR    & "10" & "000",
    I_CLR    & "00" & "101",
    I_LD     & "00" & "101",
    I_MULACC & "01",
    I_STR    & "10" & "001",
    I_CLR    & "01" & "010",
    I_LD     & "01" & "010",
    I_MULACC & "01",
    I_STR    & "10" & "010",
    I_CLR    & "01" & "111",
    I_LD     & "01" & "111",
    I_MULACC & "01",
    I_STR    & "10" & "011",
    I_CLR    & "00" & "110",
    I_LD     & "00" & "110",
    I_MULACC & "01",
    I_STR    & "10" & "100",
    I_CLR    & "00" & "111",
    I_LD     & "00" & "111",
    I_MULACC & "01",
    I_STR    & "10" & "101",
    I_CLR    & "01" & "000",
    I_LD     & "01" & "000",
    I_MULACC & "01",
    I_STR    & "10" & "110",
    I_CLR    & "01" & "001",
    I_LD     & "01" & "001",
    I_MULACC & "01",
    I_STR    & "10" & "111",
    I_HLT,

  -----------------------------------Update

    I_MPS  & "010110",
    I_MPI,
    I_CLR    & "11" & "000",
    I_LD     & "11" & "000",
    I_MULACC & "01",
    I_STR    & "10" & "000",
    I_CLR    & "01" & "000",
    I_LD     & "01" & "000",
    I_MULACC & "01",
    I_STR    & "10" & "001",
    I_CLR    & "01" & "001",
    I_LD     & "01" & "001",
    I_MULACC & "01",
    I_STR    & "10" & "010",
    I_CLR    & "01" & "010",
    I_LD     & "01" & "010",
    I_MULACC & "01",
    I_STR    & "10" & "011",
    I_CLR    & "01" & "011",
    I_LD     & "01" & "011",
    I_MULACC & "01",
    I_STR    & "10" & "100",
    I_CLR    & "11" & "001",
    I_LD     & "11" & "001",
    I_MULACC & "01",
    I_STR    & "10" & "101",
    I_CLR    & "00" & "010",
    I_LD     & "00" & "010",
    I_MULACC & "01",
    I_STR    & "10" & "110",
    I_CLR    & "00" & "011",
    I_LD     & "00" & "011",
    I_MULACC & "01",
    I_STR    & "10" & "111",
    I_MPS  & "010111",
    I_CLR    & "00" & "100",
    I_LD     & "00" & "100",
    I_MULACC & "01",
    I_STR    & "10" & "000",
    I_CLR    & "00" & "101",
    I_LD     & "00" & "101",
    I_MULACC & "01",
    I_STR    & "10" & "001",
    I_CLR    & "11" & "010",
    I_LD     & "11" & "010",
    I_MULACC & "01",
    I_STR    & "10" & "010",
    I_CLR    & "01" & "100",
    I_LD     & "01" & "100",
    I_MULACC & "01",
    I_STR    & "10" & "011",
    I_CLR    & "01" & "101",
    I_LD     & "01" & "101",
    I_MULACC & "01",
    I_STR    & "10" & "100",
    I_CLR    & "01" & "110",
    I_LD     & "01" & "110",
    I_MULACC & "01",
    I_STR    & "10" & "101",
    I_CLR    & "01" & "111",
    I_LD     & "01" & "111",
    I_MULACC & "01",
    I_STR    & "10" & "110",
    I_CLR    & "11" & "011",
    I_LD     & "11" & "011",
    I_MULACC & "01",
    I_STR    & "10" & "111",

  -----------------------------------Salsa20_u

    I_MPS  & "010111",
    I_MPI,
    I_JMP    & "0111",
    I_SLCI   & "01",
    I_JMP    & "1100",

  -----------------------------------Decrement_u

    I_SLCD   & "00",
    I_JMP    & "1101",
    I_INCLC,
    I_MPS  & "011000",
    I_CLR    & "00" & "000",
    I_LD     & "11" & "000",
    I_MULADD & "01",
    I_STR    & "00" & "000",
    I_CLR    & "00" & "001",
    I_LD     & "10" & "000",
    I_MULADD & "01",
    I_STR    & "00" & "001",
    I_CLR    & "00" & "010",
    I_LD     & "10" & "001",
    I_MULADD & "01",
    I_STR    & "00" & "010",
    I_CLR    & "00" & "011",
    I_LD     & "10" & "010",
    I_MULADD & "01",
    I_STR    & "00" & "011",
    I_CLR    & "00" & "100",
    I_LD     & "10" & "011",
    I_MULADD & "01",
    I_STR    & "00" & "100",
    I_CLR    & "00" & "101",
    I_LD     & "11" & "001",
    I_MULADD & "01",
    I_STR    & "00" & "101",
    I_CLR    & "00" & "110",
    I_LD     & "01" & "010",
    I_MULADD & "01",
    I_STR    & "00" & "110",
    I_CLR    & "00" & "111",
    I_LD     & "01" & "011",
    I_MULADD & "01",
    I_STR    & "00" & "111",
    I_MPS  & "011000",
    I_MPI,
    I_CLR    & "00" & "000",
    I_LD     & "01" & "100",
    I_MULADD & "01",
    I_STR    & "00" & "000",
    I_CLR    & "00" & "001",
    I_LD     & "01" & "101",
    I_MULADD & "01",
    I_STR    & "00" & "001",
    I_CLR    & "00" & "010",
    I_LD     & "11" & "010",
    I_MULADD & "01",
    I_STR    & "00" & "010",
    I_CLR    & "00" & "011",
    I_LD     & "10" & "100",
    I_MULADD & "01",
    I_STR    & "00" & "011",
    I_CLR    & "00" & "100",
    I_LD     & "10" & "101",
    I_MULADD & "01",
    I_STR    & "00" & "100",
    I_CLR    & "00" & "101",
    I_LD     & "10" & "110",
    I_MULADD & "01",
    I_STR    & "00" & "101",
    I_CLR    & "00" & "110",
    I_LD     & "10" & "111",
    I_MULADD & "01",
    I_STR    & "00" & "110",
    I_CLR    & "00" & "111",
    I_LD     & "11" & "011",
    I_MULADD & "01",
    I_STR    & "00" & "111",
    I_MPS  & "011011",
    I_MPI,
    I_SFID   & "1",
    I_MPS  & "011001",
    I_CLR    & "00" & "000",
    I_LD     & "10" & "000",
    I_EOR,
    I_STR    & "10" & "000",
    I_CLR    & "00" & "001",
    I_LD     & "10" & "001",
    I_EOR,
    I_STR    & "10" & "001",
    I_CLR    & "00" & "010",
    I_LD     & "10" & "010",
    I_EOR,
    I_STR    & "10" & "010",
    I_CLR    & "00" & "011",
    I_LD     & "10" & "011",
    I_EOR,
    I_STR    & "10" & "011",
    I_CLR    & "00" & "100",
    I_LD     & "10" & "100",
    I_EOR,
    I_STR    & "10" & "100",
    I_CLR    & "00" & "101",
    I_LD     & "10" & "101",
    I_EOR,
    I_STR    & "10" & "101",
    I_CLR    & "00" & "110",
    I_LD     & "10" & "110",
    I_EOR,
    I_STR    & "10" & "110",
    I_CLR    & "00" & "111",
    I_LD     & "10" & "111",
    I_EOR,
    I_STR    & "10" & "111",
    I_CLR    & "01" & "000",
    I_LD     & "11" & "000",
    I_EOR,
    I_STR    & "11" & "000",
    I_CLR    & "01" & "001",
    I_LD     & "11" & "001",
    I_EOR,
    I_STR    & "11" & "001",
    I_CLR    & "01" & "010",
    I_LD     & "11" & "010",
    I_EOR,
    I_STR    & "11" & "010",
    I_CLR    & "01" & "011",
    I_LD     & "11" & "011",
    I_EOR,
    I_STR    & "11" & "011",
    I_CLR    & "01" & "100",
    I_LD     & "11" & "100",
    I_EOR,
    I_STR    & "11" & "100",
    I_CLR    & "01" & "101",
    I_LD     & "11" & "101",
    I_EOR,
    I_STR    & "11" & "101",
    I_CLR    & "01" & "110",
    I_LD     & "11" & "110",
    I_EOR,
    I_STR    & "11" & "110",
    I_CLR    & "01" & "111",
    I_LD     & "11" & "111",
    I_EOR,
    I_STR    & "11" & "111",
    I_MPS  & "011100",
    I_CLR    & "00" & "100",
    I_LD     & "01" & "111",
    I_MULADD & "01",
    I_STR    & "00" & "100",
    I_CLR    & "00" & "101",
    I_LD     & "01" & "100",
    I_MULADDC& "01",
    I_STR    & "00" & "101",
    I_SFID   & "1",
    I_JMP    & "1110",
    I_MPS  & "011100",
    I_MPI,
    I_CLR    & "00" & "100",
    I_LD     & "00" & "100",
    I_MULACC & "01",
    I_STR    & "01" & "000",
    I_CLR    & "00" & "101",
    I_LD     & "00" & "101",
    I_MULACC & "01",
    I_STR    & "01" & "001",
    I_CLR    & "00" & "110",
    I_LD     & "00" & "110",
    I_MULACC & "01",
    I_STR    & "01" & "010",
    I_CLR    & "00" & "111",
    I_LD     & "00" & "111",
    I_MULACC & "01",
    I_STR    & "01" & "011",
    I_CLR    & "01" & "011",
    I_ST     & "01" & "100",
    I_ST     & "01" & "101",
    I_ST     & "01" & "110",
    I_ST     & "01" & "111",
    I_MPS  & "011101",
    I_CLR    & "00" & "000",
    I_LD     & "01" & "000",
    I_AND,
    I_STR    & "00" & "000",
    I_CLR    & "00" & "001",
    I_LD     & "01" & "001",
    I_AND,
    I_STR    & "00" & "001",
    I_CLR    & "00" & "010",
    I_LD     & "01" & "010",
    I_AND,
    I_STR    & "00" & "010",
    I_CLR    & "00" & "011",
    I_LD     & "01" & "011",
    I_AND,
    I_STR    & "00" & "011",
    I_CLR    & "00" & "100",
    I_LD     & "01" & "100",
    I_AND,
    I_STR    & "00" & "100",
    I_CLR    & "00" & "101",
    I_LD     & "01" & "101",
    I_AND,
    I_STR    & "00" & "101",
    I_CLR    & "00" & "110",
    I_LD     & "01" & "110",
    I_AND,
    I_STR    & "00" & "110",
    I_CLR    & "00" & "111",
    I_LD     & "01" & "111",
    I_AND,
    I_STR    & "00" & "111",
    I_MPS  & "000000",
    I_CLR    & "00" & "111",
    I_ST     & "00" & "000",
    I_ST     & "00" & "001",
    I_ST     & "00" & "010",
    I_ST     & "00" & "011",
    I_ST     & "00" & "100",
    I_ST     & "00" & "101",
    I_ST     & "00" & "110",
    I_ST     & "00" & "111",

  -----------------------------------Update_with_R1

    I_MPS  & "010101",
    I_JMP    & "0100",
    I_JMP    & "0101",
    I_MPS  & "010101",
    I_JMP    & "0110",
    I_JMP    & "0101",
    I_HLT,

  -----------------------------------Finalize

    I_MPS  & "010101",
    I_MPI,
    I_JMP    & "0100",
    I_MPS  & "010110",
    I_CLR    & "01" & "000",
    I_LD     & "01" & "000",
    I_MULACC & "01",
    I_STR    & "00" & "100",
    I_CLR    & "01" & "001",
    I_LD     & "01" & "001",
    I_MULACC & "01",
    I_STR    & "00" & "101",
    I_CLR    & "01" & "010",
    I_LD     & "01" & "010",
    I_MULACC & "01",
    I_STR    & "00" & "110",
    I_CLR    & "01" & "011",
    I_LD     & "01" & "011",
    I_MULACC & "01",
    I_STR    & "00" & "111",
    I_CLR    & "00" & "111",
    I_ST     & "00" & "000",
    I_ST     & "00" & "001",
    I_ST     & "00" & "010",
    I_ST     & "00" & "011",
    I_ST     & "11" & "000",
    I_ST     & "11" & "001",
    I_ST     & "11" & "010",
    I_ST     & "11" & "011",
    I_ST     & "11" & "100",
    I_ST     & "11" & "101",
    I_ST     & "11" & "110",
    I_ST     & "11" & "111",
    I_HLT,

  -----------------------------------Full_tag_update

    I_MPS  & "011101",
    I_MPI,
    I_JMP    & "0100",
    I_JMP    & "0101",
    I_MPS  & "011101",
    I_MPI,
    I_JMP    & "0110",
    I_JMP    & "0101",
    I_JMP    & "1111",

  -----------------------------------Add_hc_high

    I_CLR    & "00" & "000",
    I_LD     & "01" & "100",
    I_MULADD & "01",
    I_STR    & "00" & "000",
    I_CLRL   & "00" & "001",
    I_LD     & "01" & "101",
    I_MULADDC& "01",
    I_STR    & "00" & "001",
    I_CLRL   & "00" & "010",
    I_LD     & "01" & "110",
    I_MULADDC& "01",
    I_STR    & "00" & "010",
    I_CLRL   & "00" & "011",
    I_LD     & "01" & "111",
    I_MULADDC& "01",
    I_STR    & "00" & "011",
    I_CLRL   & "00" & "100",
    I_LD     & "10" & "110",
    I_MULADDC& "01",
    I_STR    & "00" & "100",
    I_CLR    & "00" & "100",
    I_ST     & "00" & "101",
    I_ST     & "00" & "110",
    I_ST     & "00" & "111",
    I_RET,

  -----------------------------------Add_hc_low

    I_CLR    & "00" & "000",
    I_LD     & "01" & "000",
    I_MULADD & "01",
    I_STR    & "00" & "000",
    I_CLRL   & "00" & "001",
    I_LD     & "01" & "001",
    I_MULADDC& "01",
    I_STR    & "00" & "001",
    I_CLRL   & "00" & "010",
    I_LD     & "01" & "010",
    I_MULADDC& "01",
    I_STR    & "00" & "010",
    I_CLRL   & "00" & "011",
    I_LD     & "01" & "011",
    I_MULADDC& "01",
    I_STR    & "00" & "011",
    I_CLRL   & "00" & "100",
    I_LD     & "10" & "110",
    I_MULADDC& "01",
    I_STR    & "00" & "100",
    I_CLR    & "00" & "100",
    I_ST     & "00" & "101",
    I_ST     & "00" & "110",
    I_ST     & "00" & "111",
    I_RET,

  -----------------------------------MulMod1305

    I_MPS  & "011110",
    I_CLR    & "00" & "000",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "000",
    I_CLRL   & "00" & "000",
    I_LD     & "01" & "001",
    I_MUL,
    I_ROL32  & "00" & "001",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "001",
    I_CLRL   & "00" & "000",
    I_LD     & "01" & "010",
    I_MUL,
    I_ROL32  & "00" & "001",
    I_LD     & "01" & "001",
    I_MUL,
    I_ROL32  & "00" & "010",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "010",
    I_CLRL   & "00" & "000",
    I_LD     & "01" & "011",
    I_MUL,
    I_ROL32  & "00" & "001",
    I_LD     & "01" & "010",
    I_MUL,
    I_ROL32  & "00" & "010",
    I_LD     & "01" & "001",
    I_MUL,
    I_ROL32  & "00" & "011",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "011",
    I_CLRL   & "00" & "000",
    I_LD     & "01" & "100",
    I_MUL,
    I_ROL32  & "00" & "001",
    I_LD     & "01" & "011",
    I_MUL,
    I_ROL32  & "00" & "010",
    I_LD     & "01" & "010",
    I_MUL,
    I_ROL32  & "00" & "011",
    I_LD     & "01" & "001",
    I_MUL,
    I_ROL32  & "00" & "100",
    I_LD     & "01" & "000",
    I_MUL,
    I_ST     & "10" & "100",
    I_CLRL   & "00" & "001",
    I_LD     & "01" & "100",
    I_MUL,
    I_ROL32  & "00" & "010",
    I_LD     & "01" & "011",
    I_MUL,
    I_ROL32  & "00" & "011",
    I_LD     & "01" & "010",
    I_MUL,
    I_ROL32  & "00" & "100",
    I_LD     & "01" & "001",
    I_MUL,
    I_ST     & "10" & "101",
    I_CLRL   & "00" & "010",
    I_LD     & "01" & "100",
    I_MUL,
    I_ROL32  & "00" & "011",
    I_LD     & "01" & "011",
    I_MUL,
    I_ROL32  & "00" & "100",
    I_LD     & "01" & "010",
    I_MUL,
    I_ST     & "10" & "110",
    I_CLRL   & "00" & "011",
    I_LD     & "01" & "100",
    I_MUL,
    I_ROL32  & "00" & "100",
    I_LD     & "01" & "011",
    I_MUL,
    I_ST     & "10" & "111",
    I_CLRL   & "00" & "100",
    I_LD     & "01" & "100",
    I_MUL,
    I_ST     & "11" & "000",
    I_MPS  & "011110",
    I_MPI,
    I_CLR    & "00" & "100",
    I_LD     & "11" & "000",
    I_AND,
    I_STR    & "10" & "000",
    I_CLR    & "00" & "101",
    I_LD     & "10" & "000",
    I_MULACC & "11",
    I_LD     & "00" & "000",
    I_ROL32  & "00" & "000",
    I_MULACC & "11",
    I_ROR2,
    I_LD     & "00" & "000",
    I_MULACC & "01",
    I_STR    & "10" & "000",
    I_CLRL   & "00" & "001",
    I_LD     & "00" & "110",
    I_RORW,
    I_MULACC & "01",
    I_ROR30,
    I_LD     & "00" & "110",
    I_MULACC & "11",
    I_ROR2,
    I_ROLW,
    I_ST     & "10" & "001",
    I_CLRL   & "00" & "010",
    I_LD     & "00" & "111",
    I_RORW,
    I_MULACC & "01",
    I_ROR30,
    I_LD     & "00" & "111",
    I_MULACC & "11",
    I_ROR2,
    I_ROLW,
    I_ST     & "10" & "010",
    I_CLRL   & "00" & "011",
    I_LD     & "01" & "000",
    I_RORW,
    I_MULACC & "01",
    I_ROR30,
    I_LD     & "01" & "000",
    I_MULACC & "11",
    I_ROR2,
    I_ROLW,
    I_ST     & "10" & "011",
    I_CLRL   & "10" & "011",
    I_RORW,
    I_STR    & "10" & "101",
    I_CLR    & "00" & "100",
    I_LD     & "11" & "001",
    I_AND,
    I_NOP    & "10" & "101",
    I_LD     & "10" & "101",
    I_MULACC & "01",
    I_STR    & "10" & "100",
    I_CLR    & "10" & "100",
    I_LD     & "11" & "000",
    I_AND,
    I_ROR2,
    I_STR    & "10" & "110",
    I_CLR    & "10" & "110",
    I_LD     & "10" & "000",
    I_MULADD & "11",
    I_STR    & "10" & "000",
    I_CLRL   & "10" & "001",
    I_LD     & "10" & "001",
    I_MULACC & "01",
    I_STR    & "10" & "001",
    I_CLRL   & "10" & "010",
    I_LD     & "10" & "010",
    I_MULACC & "01",
    I_STR    & "10" & "010",
    I_CLRL   & "10" & "011",
    I_LD     & "10" & "011",
    I_MULACC & "01",
    I_STR    & "10" & "011",
    I_CLR    & "10" & "100",
    I_LD     & "11" & "001",
    I_AND,
    I_STR    & "10" & "100",
    I_CLR    & "10" & "000",
    I_LD     & "11" & "011",
    I_MULADD & "01",
    I_RORIW,
    I_CLRL   & "10" & "001",
    I_LD     & "11" & "010",
    I_MULADDC& "01",
    I_RORIW,
    I_CLRL   & "10" & "010",
    I_LD     & "11" & "010",
    I_MULADDC& "01",
    I_RORIW,
    I_CLRL   & "10" & "011",
    I_LD     & "11" & "010",
    I_MULADDC& "01",
    I_RORIW,
    I_CLRL   & "10" & "100",
    I_LD     & "11" & "001",
    I_MULADDC& "01",
    I_RORIW,
    I_STC,
    I_CLR    & "11" & "100",
    I_LD     & "10" & "000",
    I_MULSUBC& "00",
    I_STR    & "10" & "000",
    I_CLRL   & "11" & "101",
    I_LD     & "10" & "001",
    I_MULSUBC& "00",
    I_STR    & "10" & "001",
    I_CLRL   & "11" & "101",
    I_LD     & "10" & "010",
    I_MULSUBC& "00",
    I_STR    & "10" & "010",
    I_CLRL   & "11" & "101",
    I_LD     & "10" & "011",
    I_MULSUBC& "00",
    I_STR    & "10" & "011",
    I_CLRL   & "11" & "000",
    I_LD     & "10" & "100",
    I_MULSUBC& "00",
    I_STR    & "10" & "100",
    I_CLR    & "10" & "100",
    I_ST     & "10" & "101",
    I_ST     & "10" & "110",
    I_ST     & "10" & "111",
    I_RET,

  -----------------------------------Init_r

    I_MPS  & "011111",
    I_CLR    & "00" & "000",
    I_LD     & "00" & "000",
    I_MULACC & "01",
    I_STR    & "01" & "000",
    I_CLR    & "00" & "001",
    I_LD     & "00" & "001",
    I_MULACC & "01",
    I_STR    & "01" & "001",
    I_CLR    & "00" & "010",
    I_LD     & "00" & "010",
    I_MULACC & "01",
    I_STR    & "01" & "010",
    I_CLR    & "00" & "011",
    I_LD     & "00" & "011",
    I_MULACC & "01",
    I_STR    & "01" & "011",
    I_CLR    & "00" & "100",
    I_LD     & "00" & "100",
    I_MULACC & "01",
    I_STR    & "01" & "100",
    I_CLR    & "00" & "101",
    I_LD     & "00" & "101",
    I_MULACC & "01",
    I_STR    & "01" & "101",
    I_CLR    & "00" & "110",
    I_LD     & "00" & "110",
    I_MULACC & "01",
    I_STR    & "01" & "110",
    I_CLR    & "00" & "111",
    I_LD     & "00" & "111",
    I_MULACC & "01",
    I_STR    & "01" & "111",
    I_RET,

  -----------------------------------Doubleround

    I_CLR    & "00" & "000",
    I_LD     & "01" & "100",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL7,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "100",
    I_EOR,
    I_STR    & "00" & "100",
    I_CLR    & "00" & "101",
    I_LD     & "00" & "001",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL7,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "001",
    I_EOR,
    I_STR    & "01" & "001",
    I_CLR    & "01" & "010",
    I_LD     & "00" & "110",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL7,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "110",
    I_EOR,
    I_STR    & "01" & "110",
    I_CLR    & "01" & "111",
    I_LD     & "01" & "011",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL7,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "011",
    I_EOR,
    I_STR    & "00" & "011",
    I_CLR    & "00" & "100",
    I_LD     & "00" & "000",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL9,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "000",
    I_EOR,
    I_STR    & "01" & "000",
    I_CLR    & "01" & "001",
    I_LD     & "00" & "101",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL9,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "101",
    I_EOR,
    I_STR    & "01" & "101",
    I_CLR    & "01" & "110",
    I_LD     & "01" & "010",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL9,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "010",
    I_EOR,
    I_STR    & "00" & "010",
    I_CLR    & "00" & "011",
    I_LD     & "01" & "111",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL9,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "111",
    I_EOR,
    I_STR    & "00" & "111",
    I_CLR    & "01" & "000",
    I_LD     & "00" & "100",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL13,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "100",
    I_EOR,
    I_STR    & "01" & "100",
    I_CLR    & "01" & "101",
    I_LD     & "01" & "001",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL13,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "001",
    I_EOR,
    I_STR    & "00" & "001",
    I_CLR    & "00" & "010",
    I_LD     & "01" & "110",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL13,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "110",
    I_EOR,
    I_STR    & "00" & "110",
    I_CLR    & "00" & "111",
    I_LD     & "00" & "011",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL13,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "011",
    I_EOR,
    I_STR    & "01" & "011",
    I_CLR    & "01" & "100",
    I_LD     & "01" & "000",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL18,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "000",
    I_EOR,
    I_STR    & "00" & "000",
    I_CLR    & "00" & "001",
    I_LD     & "01" & "101",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL18,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "101",
    I_EOR,
    I_STR    & "00" & "101",
    I_CLR    & "00" & "110",
    I_LD     & "00" & "010",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL18,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "010",
    I_EOR,
    I_STR    & "01" & "010",
    I_CLR    & "01" & "011",
    I_LD     & "00" & "111",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL18,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "111",
    I_EOR,
    I_STR    & "01" & "111",
    I_CLR    & "00" & "000",
    I_LD     & "00" & "011",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL7,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "001",
    I_EOR,
    I_STR    & "00" & "001",
    I_CLR    & "00" & "101",
    I_LD     & "00" & "100",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL7,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "110",
    I_EOR,
    I_STR    & "00" & "110",
    I_CLR    & "01" & "010",
    I_LD     & "01" & "001",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL7,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "011",
    I_EOR,
    I_STR    & "01" & "011",
    I_CLR    & "01" & "111",
    I_LD     & "01" & "110",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL7,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "100",
    I_EOR,
    I_STR    & "01" & "100",
    I_CLR    & "00" & "001",
    I_LD     & "00" & "000",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL9,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "010",
    I_EOR,
    I_STR    & "00" & "010",
    I_CLR    & "00" & "110",
    I_LD     & "00" & "101",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL9,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "111",
    I_EOR,
    I_STR    & "00" & "111",
    I_CLR    & "01" & "011",
    I_LD     & "01" & "010",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL9,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "000",
    I_EOR,
    I_STR    & "01" & "000",
    I_CLR    & "01" & "100",
    I_LD     & "01" & "111",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL9,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "101",
    I_EOR,
    I_STR    & "01" & "101",
    I_CLR    & "00" & "010",
    I_LD     & "00" & "001",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL13,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "011",
    I_EOR,
    I_STR    & "00" & "011",
    I_CLR    & "00" & "111",
    I_LD     & "00" & "110",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL13,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "100",
    I_EOR,
    I_STR    & "00" & "100",
    I_CLR    & "01" & "000",
    I_LD     & "01" & "011",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL13,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "001",
    I_EOR,
    I_STR    & "01" & "001",
    I_CLR    & "01" & "101",
    I_LD     & "01" & "100",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL13,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "110",
    I_EOR,
    I_STR    & "01" & "110",
    I_CLR    & "00" & "011",
    I_LD     & "00" & "010",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL18,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "000",
    I_EOR,
    I_STR    & "00" & "000",
    I_CLR    & "00" & "100",
    I_LD     & "00" & "111",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL18,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "00" & "101",
    I_EOR,
    I_STR    & "00" & "101",
    I_CLR    & "01" & "001",
    I_LD     & "01" & "000",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL18,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "010",
    I_EOR,
    I_STR    & "01" & "010",
    I_CLR    & "01" & "110",
    I_LD     & "01" & "101",
    I_MULADD & "01",
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "000",
    I_MULACC & "01",
    I_ROL18,
    I_STR    & "10" & "000",
    I_RORW,
    I_RORIW,
    I_ST     & "10" & "001",
    I_CLR    & "10" & "000",
    I_LD     & "10" & "001",
    I_OR,
    I_STR    & "10" & "000",
    I_CLR    & "10" & "000",
    I_LD     & "01" & "111",
    I_EOR,
    I_STR    & "01" & "111",
    I_RET,
---------------------------------------------------------
    I_NOP    & "00000"
  );

  signal code0 : std_logic_vector(8 downto 0);
  signal code1 : std_logic_vector(8 downto 0);
begin

  code0 <= program_rom0(conv_integer(program_counter));
  code1 <= program_rom1(conv_integer(program_counter));

  romMux : process(sel_start_point, code0, code1) begin
    if sel_start_point > 1 and PROGRAM_ROMS = 2 then
      code <= code1;
    else
      code <= code0;
    end if;
  end process;

end;

