
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_count_to_3 is
  port( 
    clk      :  in std_logic;
    en       :  in std_logic;
    rst      :  in std_logic;
    counter  : out std_logic_vector(1 downto 0);
    overflow : out std_logic
  );
end nacl_count_to_3;

architecture behaviour of nacl_count_to_3 is --73 

  signal counter_data : std_logic_vector(1 downto 0);
  signal counter_inc  : std_logic_vector(1 downto 0);
  signal counter_next : std_logic_vector(1 downto 0);

begin

  storage : process(clk, rst, en) begin
    if rst = '1' then
      counter_data <= (others => '0');
    elsif rising_edge(clk) and en = '1' then
      counter_data <= counter_next;
    end if;   
  end process;
  
  counter_inc  <= counter_data(1) & not counter_data(1);
  counter_next <= counter_data + counter_inc;
  counter      <= counter_data;
  overflow     <= counter_data(1);
     
end;