
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_counter is
  generic (
    WIDTH: integer
  );
  port(
    clk      :  in std_logic;
    en       :  in std_logic;
    rst      :  in std_logic;
    counter  : out std_logic_vector(WIDTH-1 downto 0);
    overflow : out std_logic
  );
end nacl_counter;

architecture behaviour of nacl_counter is

  constant MAX : std_logic_vector(WIDTH-1 downto 0) := (others => '1');

  signal counter_data : std_logic_vector(WIDTH-1 downto 0);
  signal counter_next : std_logic_vector(WIDTH-1 downto 0);

begin

  storage : process(clk, rst, en) begin
    if rst = '1' then
      counter_data <= (others => '0');
    elsif rising_edge(clk) and en = '1' then
      counter_data <= counter_next;
    end if;
  end process;

  overflowP : process(counter_data) begin
    if counter_data = MAX then
      overflow <= '1';
    else
      overflow <= '0';
    end if;
  end process;

  counter_next <= counter_data + 1;
  counter      <= counter_data;

end;
