
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity nacl_dynamic_logic_cell is
  port(
    a      :  in std_logic;
    b      :  in std_logic;
    c      : out std_logic;
    xor_en :  in std_logic;
    or_en  :  in std_logic
  );
end nacl_dynamic_logic_cell;

architecture behaviour0 of nacl_dynamic_logic_cell is -- 24 sq mu meter

  signal or0   : std_logic;
  signal nand0 : std_logic;
  signal nand1 : std_logic;
  signal nand2 : std_logic;
  signal nand3 : std_logic;
  signal nand4 : std_logic;

begin

  or0   <= or_en or xor_en;
  nand0 <= (not or_en) nand b;
  nand1 <=  a nand nand0;
  nand2 <= nand1 nand nand4;
  nand3 <= (not a) nand or0;
  nand4 <= (not nand3) nand b;
  c <= nand2;

end;

architecture behaviour1 of nacl_dynamic_logic_cell is -- 38 sq mu meter

  type rom_type is array(0 to 15) of std_logic;
  constant rom : rom_type := (
     '0', '1', '0', '0',
     '0', '1', '1', '0',
     '0', '1', '1', '1',
     '-', '-', '-', '-'
  );

begin

  c <= rom(conv_integer(or_en & xor_en & b & a));

end;
