library ieee; 
use ieee.std_logic_1164.all; 

entity nacl_fulladder_dynamic is 
  port ( 
    a        :  in std_logic;
    b        :  in std_logic;
    cin      :  in std_logic; 
    sum      : out std_logic;
    cout     : out std_logic;
    xor_en   :  in std_logic;
    or_en    :  in std_logic;
    adder_en :  in std_logic
  ); 
end entity nacl_fulladder_dynamic; 

architecture behaviour of nacl_fulladder_dynamic is

  signal logic_out : std_logic;
  signal xor_en2   : std_logic;

begin

  logic0 : entity work.nacl_dynamic_logic_cell(behaviour0)
    port map(
      a      => a,
      b      => b,
      c      => logic_out,
      xor_en => xor_en2,
      or_en  => or_en
    ); 

  sum     <= logic_out xor (adder_en and cin);
  cout    <=(a and b) or (a and cin) or (b and cin);
  xor_en2 <= xor_en or adder_en;
                                
end;