
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

use work.nacl_constants.all;

entity nacl_memory_address_logic is
  port (
    switch_state  :  in std_logic;
    address_in  :  in std_logic_vector(ADDRESS_WIDTH_RAM-4 downto 0);
    address_out : out std_logic_vector(ADDRESS_WIDTH_RAM-4 downto 0)
  );
end nacl_memory_address_logic;

architecture behaviour of nacl_memory_address_logic is

begin

  addressLogic : process(address_in, switch_state) begin
    if conv_integer(address_in) > 1 and conv_integer(address_in) < 6 then
      address_out <= address_in(ADDRESS_WIDTH_RAM-4 downto 1) & (address_in(0) xor switch_state);    
    else
      address_out <= address_in;
    end if;
  end process;

end;
