
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

use work.nacl_constants.all;

entity nacl_memory_output_selection_logic is
  port (
    clk                   :  in std_logic;
    rst                   :  in std_logic;
    en_bufALU             :  in std_logic;
    address               :  in std_logic_vector(ADDRESS_WIDTH-1 downto 0);
    address_rom_buffer_en : out std_logic;
    output_sel            : out std_logic
  );
end nacl_memory_output_selection_logic;

architecture behaviour of nacl_memory_output_selection_logic is 
  
  signal address_sel_del : std_logic;
  signal address_sel     : std_logic;

begin
  
  comparator : process(address) begin
    if conv_integer(address) < RAM_SIZE then
      address_sel <= '0';
    else
      address_sel <= '1';            
    end if;
  end process;    
  
  adressSelDel : process(rst, clk) begin
    if rst = '1' then
      address_sel_del <= '0';
    elsif rising_edge(clk) then
      address_sel_del <= address_sel;
    end if;
  end process;
  
  output_sel <= en_bufALU or address_sel_del; 
  
  address_rom_buffer_en <= address_sel;
  
end;
