
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity nacl_memory_ram is
  generic (
    WIDTH   : integer;
    SIZE    : integer;
    SIZE_LD : integer
  );
  port (
    clk  :  in std_logic;
    we   :  in std_logic;
    addr :  in std_logic_vector(SIZE_LD-1 downto 0);
    di   :  in std_logic_vector(WIDTH-1 downto 0);
    do   : out std_logic_vector(WIDTH-1 downto 0)
  );
end nacl_memory_ram;

architecture behaviour of nacl_memory_ram is

  type ram_type is array (SIZE-1 downto 0) of std_logic_vector (WIDTH-1 downto 0);
  signal RAM : ram_type;

begin

  process (clk) begin
    if rising_edge(clk) then
      if we = '1' then
        RAM(conv_integer(addr)) <= di;
      end if;
        do <= RAM( conv_integer(addr));
    end if;
  end process;

end;

