
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

use work.nacl_constants.all;

entity nacl_memory_rom is
  port(
    address_rom : in std_logic_vector(ADDRESS_WIDTH_ROM-1 downto 0);
    data_out    : out std_logic_vector(WORD_SIZE-1 downto 0)
  );
end nacl_memory_rom;

architecture behaviour of nacl_memory_rom is

  constant alu_rom : alu_constants_rom := ALU_CONSTANTS;

begin

  data_out <= alu_rom(conv_integer(address_rom));

end;

