
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_mux2 is
  generic (
    WIDTH: integer
  );
  port(
    in0  :  in std_logic_vector(WIDTH-1 downto 0);
    in1  :  in std_logic_vector(WIDTH-1 downto 0);
    outp : out std_logic_vector(WIDTH-1 downto 0);
    sel  :  in std_logic
  );
end nacl_mux2;

architecture behaviour of nacl_mux2 is

begin

  multiplexer : process(sel, in0, in1) begin
    case sel is
      when '0'    => outp <= in0;
      when others => outp <= in1;
    end case;
  end process;

end;
