
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_mux4 is
  generic ( 
    WIDTH: integer 
  );
  port ( 
    in0  :  in std_logic_vector(WIDTH-1 downto 0);
    in1  :  in std_logic_vector(WIDTH-1 downto 0);
    in2  :  in std_logic_vector(WIDTH-1 downto 0);
    in3  :  in std_logic_vector(WIDTH-1 downto 0);
    outp : out std_logic_vector(WIDTH-1 downto 0);
    sel  :  in std_logic_vector(1 downto 0)
  );
end nacl_mux4;

architecture behaviour of nacl_mux4 is

begin

  multiplexer : process(sel, in0, in1, in2, in3) begin
    case sel is
      when "00"   => outp <= in0;
      when "01"   => outp <= in1;
      when "10"   => outp <= in2;
      when others => outp <= in3;
    end case;
  end process;

end;
