
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_register is
  generic (
    WIDTH:       integer
  );
  port (
    clk  :  in std_logic;
    rst  :  in std_logic;
    en   :  in std_logic;
    din  :  in std_logic_vector(WIDTH-1 downto 0);
    dout : out std_logic_vector(WIDTH-1 downto 0)
  );
end nacl_register;

architecture behaviour of nacl_register is

  signal data : std_logic_vector(WIDTH-1 downto 0);

begin

  dout <= data;

  process(clk, rst, en, din) begin
    if rst = '1' then
      data <= (others => '0');
    elsif rising_edge(clk) and en = '1' then
      data <= din;
    end if;
  end process;

end;
