
library ieee;
use ieee.numeric_std.all;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

use work.nacl_constants.all;

entity nacl_secure_bit_buffer is
  generic (
    initial : std_logic_vector(3 downto 0) := "1010"
  );
  port (
    clk  :  in std_logic;
    rst  :  in std_logic;
    din  :  in std_logic;
    dout : out std_logic;
    en   :  in std_logic
  );
end nacl_secure_bit_buffer;

architecture behaviour of nacl_secure_bit_buffer is

  signal bit_buffer      : std_logic_vector(3 downto 0);
  signal bit_buffer_next : std_logic_vector(3 downto 0);
  signal bit_buffer_en   : std_logic;

begin

  BitBuffer : process(rst, clk) begin
    if rst = '1' then
      bit_buffer <= initial;
    elsif rising_edge(clk) then
      if en = '1' and bit_buffer_en = '1' then
        bit_buffer(1 downto 0) <= bit_buffer_next(1 downto 0);
      elsif en = '1' and bit_buffer_en = '0' then
        bit_buffer(3 downto 2) <= bit_buffer_next(3 downto 2);
      end if;
    end if;
  end process;

  bit_buffer_en   <= din xor bit_buffer(0);
  bit_buffer_next <= bit_buffer(2) & bit_buffer(3) & bit_buffer(0) & bit_buffer(1);

  dout <= bit_buffer(1) nor (bit_buffer(2) nor bit_buffer(3));

end;
