
library ieee;       
use ieee.numeric_std.all;                                                  
use ieee.std_logic_1164.all;                                          
use ieee.std_logic_unsigned.all; 

use std.textio.all;
use ieee.std_logic_textio.all;

use work.nacl_constants.all;

entity testbench is
end testbench;

architecture behaviour of testbench is 

  constant PERIOD   : time    :=   1 ns;
  
  signal clk    : std_logic := '0';
  signal rst    : std_logic;
  signal paddr  : std_logic_vector(1 downto 0);
  signal pwrite : std_logic;
  signal pwdata : std_logic_vector(WORD_SIZE-1 downto 0);
  signal prdata : std_logic_vector(WORD_SIZE-1 downto 0);

begin

  nacl : entity work.nacl
    port map ( 
      pclk    => clk,
  	   presetn => rst,
	   paddr   => paddr,
	   psel    => '1',
      penable => '1',
      pwrite  => pwrite,
	   pwdata  => pwdata,
	   prdata  => prdata
    );
    
  testbench : process is
    variable io : line;
  begin
  
    ------------------------ RST ----------------
    rst    <= '0';
    paddr  <= "00";
	 pwrite <= '0';
    pwdata <= (others => '0');
	 wait for PERIOD;
	 
	 rst    <= '1';
    paddr  <= "00";
	 pwrite <= '0';
    pwdata <= (others => '0');	 
	 wait for PERIOD;
    
    ------------------------ RUN ----------------
    
    rst    <= '1';
    paddr  <= "00";
	 pwrite <= '1';
    pwdata <= (others => '0');	 
	 wait for PERIOD;
    
    rst    <= '1';
    paddr  <= "00";
	 pwrite <= '0';
    pwdata <= (others => '0');	 	     
	 wait until prdata(1) = '1';
    
    if prdata(0) = '1' then
      write(io, "ERROR!!");
      writeline(output, io);
    else
      write(io, "PASSED!!");
      writeline(output, io);
    end if;
    wait for PERIOD;

    ------------------------ PRINT --------------

   
    writeline(output, io);
    write(io, "========================================");
    writeline(output, io);
    
    for i in 0 to 1 loop
      write(io, "@");
      write(io, i);
      write(io, ": ");      
      for j in 7 downto 0 loop
        paddr  <= "11";
        pwdata <= std_logic_vector(to_unsigned(i*8+j, WORD_SIZE));
        wait for 2*PERIOD;
        hwrite(io, prdata);
        write(io, " ");
      end loop;
      writeline(output, io);
    end loop;
    
    paddr  <= "01";
    wait for 2*PERIOD;
    write(io, "needed ");
    write(io, conv_integer(prdata));
    write(io, " cycles");
    writeline(output, io);
    
    wait;
  end process;
  
  clk_process : process begin
    clk <= '0';
	 wait for PERIOD/2;
	 clk <= '1';
	 wait for PERIOD/2;
  end process; 
   
end;
