
library ieee;       
use ieee.numeric_std.all;                                                  
use ieee.std_logic_1164.all;                                          
use ieee.std_logic_unsigned.all; 

use std.textio.all;
use ieee.std_logic_textio.all;

use work.nacl_constants.all;

entity testbench_salsa20poly1305 is
end testbench_salsa20poly1305;

architecture behaviour of testbench_salsa20poly1305 is

--  file stimulus: TEXT open read_mode is "../../../NaCL.srcs/sources_1/imports/test/testvectors.txt";
--  file result_tag: TEXT open write_mode is "../../../NaCL.srcs/sources_1/imports/test/result_tag.txt";
--  file result_cipher: TEXT open write_mode is "../../../NaCL.srcs/sources_1/imports/test/result_cipher.txt";
--  file result_written: TEXT open write_mode is "../../../NaCL.srcs/sources_1/imports/test/result_written.txt";
--  file init_log: TEXT open write_mode is "../../../NaCL.srcs/sources_1/imports/test/init_log.txt";
  
  file stimulus: TEXT open read_mode is "../test/testvectors.txt";
  file result_tag: TEXT open write_mode is "../test/result_tag.txt";
  file result_cipher: TEXT open write_mode is "../test/result_cipher.txt";
  file result_written: TEXT open write_mode is "../test/result_written.txt";
  file init_log: TEXT open write_mode is "../test/init_log.txt";
  
  constant PERIOD   : time    :=   1 ns;
  constant NUM_REGISTER_USED    : integer   :=  2;
  constant INPUT_DATA_SIZE  : integer := 8 * NUM_REGISTER_USED - 1;
  
  signal clk    : std_logic := '0';
  signal rst    : std_logic;
  signal paddr  : std_logic_vector(1 downto 0);
  signal pwrite : std_logic;
  signal pwdata : std_logic_vector(WORD_SIZE-1 downto 0);
  signal prdata : std_logic_vector(WORD_SIZE-1 downto 0);

begin

  nacl : entity work.nacl
    port map ( 
      pclk    => clk,
      presetn => rst,
      paddr   => paddr,
      psel    => '1',
      penable => '1',
      pwrite  => pwrite,
      pwdata  => pwdata,
      prdata  => prdata
    );
    
  testbench_salsa20poly1305 : process is
    variable io : line;
    variable rdline : line;
    variable wrline : line;
	variable initlogline : line;
	variable tagline : line;
    variable hex : std_logic_vector(WORD_SIZE-1 downto 0); 
    variable j: integer range 0 to 31;
    variable vector_counter: integer range 0 to 10000;
    variable num_blocks: integer range 0 to 10000;
    variable block_counter: integer range 0 to 10000;
	variable init: integer := 0;
	variable is_first_block: integer := 1;
	variable update: integer := 2;
	variable finalize: integer := 3;
  begin
  
  vector_counter := 0;
  num_blocks := 0;
  block_counter := 0;
  
  while not endfile(stimulus) loop --Loop over whole textvector file
  
    write(io, string'("Processing Vector: "));
    write(io, vector_counter);
	write(io, string'(" | "));
    --writeline(output, io);
    
    block_counter := 0;
  
    ------------------------ RST ----------------
    --write(io, string'("Resetting..."));
    j := 7;
    rst    <= '0';
    paddr  <= "00";
    pwrite <= '0';
    pwdata <= std_logic_vector(to_unsigned(init, WORD_SIZE));
    wait for PERIOD;
     
    rst    <= '1';
    paddr  <= "00";
    pwrite <= '0';
    pwdata <= std_logic_vector(to_unsigned(init, WORD_SIZE));     
    wait for PERIOD;
     
     
    --write(io, string'("done!"));
    --writeline(output, io);
    
    readline(stimulus, rdline);
    read(rdline, num_blocks);
    
    --write(io, string'("Message Length is "));
    write(io, num_blocks);
    --write(io, string'(" 64byte Blocks"));
    writeline(output, io);
    
   ------------------------ WR Key in R6 ------------ 
    
	readline(stimulus, rdline);
    for i in 48 to 55 loop
      rst    <= '1';
      paddr  <= "11";
      pwrite <= '1';
	  pwdata <= std_logic_vector(to_unsigned(i, WORD_SIZE)); -- address 48 -> 55 key
      wait for PERIOD; 
       
      rst    <= '1';
      paddr  <= "10";
      pwrite <= '1';
      
      hread(rdline, hex);
      pwdata <= hex;
      wait for PERIOD;
      pwrite <= '0';
      wait for PERIOD;
           
      --hwrite(io, hex);
    end loop;
	--writeline(output, io);

    ------------------------ WR Nonce in R0 ------------ 
    readline(stimulus, rdline);
    for i in 0 to 7 loop
      rst    <= '1';
      paddr  <= "11";
      pwrite <= '1';
	  pwdata <= std_logic_vector(to_unsigned(i, WORD_SIZE)); -- address 0 -> 7 nonce
      wait for PERIOD; 
       
      rst    <= '1';
      paddr  <= "10";
      pwrite <= '1';
      
      hread(rdline, hex);
      pwdata <= hex;
      wait for PERIOD;
      pwrite <= '0';
      wait for PERIOD;
           
      --hwrite(io, hex);
    end loop;
	
	--writeline(output, io);
	
	 ------------------------ RUN INIT----------------
      --write(io, string'("Running init..."));
      --writeline(output, io);
	  
      rst    <= '1';
      paddr  <= "00";
      pwrite <= '1';
      pwdata <= std_logic_vector(to_unsigned(init, WORD_SIZE));     
      wait for PERIOD;
        
      rst    <= '1';
      paddr  <= "00";
      pwrite <= '0';
      pwdata <= std_logic_vector(to_unsigned(init, WORD_SIZE));  
      wait until prdata(1) = '1';
         
      if prdata(0) = '1' then
        write(io, string'("ERROR!!"));
        writeline(output, io);
        wait;
      end if;
      wait for PERIOD;
	  
	  
	  ------------------------ PRINT --------------
      write(initlogline, string'("Read Data INIT..."));
      writeline(init_log, initlogline);
      write(initlogline, string'("========================================"));
      writeline(init_log, initlogline);
        

      for i in 0 to 8 loop
        write(initlogline,  string'("@"));
        write(initlogline, i);
        write(initlogline,  string'(": "));      
        for j in 0 to 7 loop
          paddr  <= "11";
          pwdata <= std_logic_vector(to_unsigned(i*8+j, WORD_SIZE));
          wait for 2*PERIOD;
          hwrite(initlogline, prdata);
          write(initlogline,  string'(" "));
          if (j = 3) then
            writeline(init_log, initlogline);
            write(initlogline,  string'("    "));
          end if;
        end loop;
        writeline(init_log, initlogline);
      end loop;
      writeline(init_log, initlogline);

	  
    while (block_counter < num_blocks) loop --Loop over whole message
    
      ------------------------ WR Data ------------
      --write(io, string'("Writing Data Block..."));
      --write(io, block_counter);
      --writeline(output, io);
        
      for i in INPUT_DATA_SIZE downto 0 loop
        IF (j = 7) THEN
          j := 0;
          readline(stimulus, rdline);
        ELSE
          j := j + 1;
        END IF;
           
        rst    <= '1';
        paddr  <= "11";
        pwrite <= '1';
        pwdata <= std_logic_vector(to_unsigned(INPUT_DATA_SIZE - i, WORD_SIZE)); -- address 0 -> 31
        wait for PERIOD; 
           
        rst    <= '1';
        paddr  <= "10";
		pwrite <= '1';
        
          
        hread(rdline, hex);
        pwdata <= hex;
        wait for PERIOD;
        pwrite <= '0';
        wait for PERIOD;
           
        --hwrite(io, hex);
      end loop;
      --writeline(output, io);    
      --write(io, string'("done!"));
      --writeline(output, io);
        
      ------------------------ RUN UPDATE----------------
      --write(io, string'("Running..."));
        
      rst    <= '1';
      paddr  <= "00";
      pwrite <= '1';
	  if block_counter = 0 then
		pwdata <= std_logic_vector(to_unsigned(is_first_block, WORD_SIZE)); 
	  else
		pwdata <= std_logic_vector(to_unsigned(update, WORD_SIZE)); 
	  end if;
      wait for PERIOD;
        
      rst    <= '1';
      paddr  <= "00";
      pwrite <= '0';
      if block_counter = 0 then
		pwdata <= std_logic_vector(to_unsigned(is_first_block, WORD_SIZE)); 
	  else
		pwdata <= std_logic_vector(to_unsigned(update, WORD_SIZE)); 
	  end if;          
      wait until prdata(1) = '1';
         
      if prdata(0) = '1' then
        write(io, string'("ERROR!!"));
        writeline(output, io);
        wait;
      end if;
      wait for PERIOD;
   
      --write(io, string'("done!"));
     -- writeline(output, io);

      ------------------------ PRINT --------------
      --write(io, string'("Read Data Update..."));
      --writeline(output, io);
      --write(io, string'("========================================"));
      --writeline(output, io);
        

      for i in 0 to 8 loop
        ----write(io,  string'("@"));
        ----write(io, i);
        ----write(io,  string'(": "));      
        for j in 0 to 7 loop
          paddr  <= "11";
          pwdata <= std_logic_vector(to_unsigned(i*8+j, WORD_SIZE));
          wait for 2*PERIOD;
          ----hwrite(io, prdata);
		  hwrite(wrline, prdata); --write to file
          ----write(io,  string'(" "));
          if (j = 3) then
            ----writeline(output, io);
            ----write(io,  string'("    "));
          end if;
        end loop;
        ----writeline(output, io);
        if ( i = 0 or i = 1) then
			if (block_counter > 0 or i = 1) then
				writeline(result_cipher, wrline);
			else
				writeline(result_written, wrline);
			end if;
        else
          writeline(result_written, wrline);
        end if;
      end loop;
	  block_counter := block_counter + 1;
      ----writeline(output, io);

    end loop;


	------------------------ RUN Finalize----------------
      ----write(io, string'("Running...finalize"));
	  ----writeline(output, io);
        
      rst    <= '1';
      paddr  <= "00";
      pwrite <= '1';
	  pwdata <= std_logic_vector(to_unsigned(finalize, WORD_SIZE)); 
      wait for PERIOD;
        
      rst    <= '1';
      paddr  <= "00";
      pwrite <= '0';
	  pwdata <= std_logic_vector(to_unsigned(finalize, WORD_SIZE));      
      wait until prdata(1) = '1';
         
      if prdata(0) = '1' then
        write(io, string'("ERROR!!"));
        writeline(output, io);
        wait;
      end if;
      wait for PERIOD;
	  
	  
	------------------------ PRINT --------------
      write(tagline, string'("Read Data Finalize..."));
      
      writeline(result_tag, tagline);
      write(tagline, string'("========================================"));
      writeline(result_tag, tagline);
        

      for i in 0 to 8 loop
        write(tagline,  string'("@"));
        write(tagline, i);
        write(tagline,  string'(": "));      
        for j in 0 to 7 loop
          paddr  <= "11";
          pwdata <= std_logic_vector(to_unsigned(i*8+j, WORD_SIZE));
          wait for 2*PERIOD;
          hwrite(tagline, prdata);
		  hwrite(wrline, prdata);
          write(tagline,  string'(" "));
          if (j = 3) then
            writeline(result_tag, tagline);
            write(tagline,  string'("    "));
          end if;
        end loop;
		if ( i = 0) then
          writeline(result_cipher, wrline);
		end if;
        writeline(result_tag, tagline);
      end loop;
      writeline(result_tag, tagline);
	
	
	
    paddr  <= "01";
    wait for 2*PERIOD;
    
    --write(io, string'("done!("));
    --write(io, conv_integer(prdata));
    --write(io,  string'(" cycles)"));
    --writeline(output, io);
    
    vector_counter := vector_counter + 1;

    end loop;
	wait;
  end process;
  
  clk_process : process begin
    clk <= '0';
     wait for PERIOD/2;
     clk <= '1';
     wait for PERIOD/2;
  end process; 
   
end;
