# This is a corrected version of fe25519r64_mul-1.q (which is same as
# fe25519r64_mul-2.q, fe25519r64_mul-3.q, and fe25519r64_mul-4.q).
# In this file, we verify equality relations.

# CPU: Intel(R) Xeon(R) CPU X5675 @ 3.07GHz
# RAM: 32GB
# Configuration: -c consts -s
# With Boolector 1.6.0 (-minisat): 73m55.159s

int64 rp
int64 xp
int64 yp

input rp
input xp
input yp

int64 r0
int64 r1
int64 r2
int64 r3


int64 caller1
int64 caller2
int64 caller3
int64 caller4
int64 caller5
int64 caller6
int64 caller7
caller caller1
caller caller2
caller caller3
caller caller4
caller caller5
caller caller6
caller caller7
stack64 caller1_stack
stack64 caller2_stack
stack64 caller3_stack
stack64 caller4_stack
stack64 caller5_stack
stack64 caller6_stack
stack64 caller7_stack

int64 r4
int64 r5
int64 r6
int64 r7
int64 r8
int64 rax
int64 rdx
int64 x0
int64 x1
int64 x2
int64 x3
int64 c
int64 zero
int64 i38

enter fe25519_mul

###################################################################
# Conditions on the inputs: x0 = *(uint64 *)(xp +  0),
#                           x1 = *(uint64 *)(xp +  8),
#                           x2 = *(uint64 *)(xp + 16),
#                           x3 = *(uint64 *)(xp + 24),
#                           y0 = *(uint64 *)(yp +  0),
#                           y1 = *(uint64 *)(yp +  8),
#                           y2 = *(uint64 *)(yp + 16)  
#                           y3 = *(uint64 *)(yp + 24) are all arbitrary 64-bit unsigned integers
#
###################################################################



caller1_stack = caller1
caller2_stack = caller2
caller3_stack = caller3
caller4_stack = caller4
caller5_stack = caller5
caller6_stack = caller6
caller7_stack = caller7

yp = yp


  #BEGIN MACRO 
  r4 = 0
  r5 = 0
  r6 = 0
  r7 = 0
  
  x0 = *(uint64 *)(xp + 0)
  rax = *(uint64 *)(yp + 0)
  (uint128) rdx rax = rax * x0
  r0 = rax
  r1 = rdx
  
  rax = *(uint64 *)(yp + 8)
  (uint128) rdx rax = rax * x0
  carry? r1 += rax
  r2 = 0
  r2 += rdx + carry
  
  rax = *(uint64 *)(yp + 16)
  (uint128) rdx rax = rax * x0
  carry? r2 += rax
  r3 = 0
  r3 += rdx + carry
  
  rax = *(uint64 *)(yp + 24)
  (uint128) rdx rax = rax * x0
  carry? r3 += rax
  r4 += rdx + carry

  #// var A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192
  #// cut r5 = 0 && r6 = 0 && r7 = 0 &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + r4@u512 * 2**256 = A0
  
  x1 = *(uint64 *)(xp + 8)
  rax = *(uint64 *)(yp + 0)
  (uint128) rdx rax = rax * x1
  carry? r1 += rax
  c = 0
  c += rdx + carry

  #// var B0 = A0 + (xp[8]@u128 * yp[0]@u128)@u512 * 2**64
  #// cut r5 = 0 && r6 = 0 && r7 = 0 && x1 = xp[8] &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     B0 = A0 + (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 &&
  #//     r0@u512 + r1@u512 * 2**64 + (r2@u65 + c@u65)@u512 * 2**128 + r3@u512 * 2**192 + r4@u512 * 2**256 = B0
  
  rax = *(uint64 *)(yp + 8)
  (uint128) rdx rax = rax * x1
  carry? r2 += rax
  rdx += 0 + carry
  carry? r2 += c
  c = 0
  c += rdx + carry
  
  #// var B1 = B0 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128
  #// cut r5 = 0 && r6 = 0 && r7 = 0 && x1 = xp[8] &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     B0 = A0 + (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 &&
  #//     B1 = B0 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + (r3@u65 + c@u65)@u512 * 2**192 + r4@u512 * 2**256 = B1

  rax = *(uint64 *)(yp + 16)
  (uint128) rdx rax = rax * x1
  carry? r3 += rax 
  rdx += 0 + carry
  carry? r3 += c
  c = 0
  c += rdx + carry

  #// var B2 = B1 + (xp[8]@u128 * yp[16]@u128)@u512 * 2**192
  #// cut r5 = 0 && r6 = 0 && r7 = 0 && x1 = xp[8] &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     B0 = A0 + (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 &&
  #//     B1 = B0 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 &&
  #//     B2 = B1 + (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + (r4@u65 + c@u65)@u512 * 2**256 = B2

  rax = *(uint64 *)(yp + 24)
  (uint128) rdx rax = rax * x1
  carry? r4 += rax
  rdx += 0 + carry
  carry? r4 += c
  r5 += rdx + carry

  #// var B3 = B2 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256
  #// cut r6 = 0 && r7 = 0 &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     B0 = A0 + (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 &&
  #//     B1 = B0 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 &&
  #//     B2 = B1 + (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 &&
  #//     B3 = B2 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + r4@u512 * 2**256 + r5@u512 * 2**320 = B3

  #// var A1 = A0 +
  #//         (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 +
  #//         (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256
  #// cut r6 = 0 && r7 = 0 &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     A1 = A0 +
  #//         (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 +
  #//         (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + r4@u512 * 2**256 + r5@u512 * 2**320 = A1
    
  x2 = *(uint64 *)(xp + 16)
  rax = *(uint64 *)(yp + 0)
  (uint128) rdx rax = rax * x2
  carry? r2 += rax
  c = 0
  c += rdx + carry

  #// var C0 = A1 + (xp[16]@u128 * yp[0]@u128)@u512 * 2**128
  #// cut r6 = 0 && r7 = 0 && x2 = xp[16] &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     A1 = A0 +
  #//         (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 +
  #//         (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256 &&
  #//     C0 = A1 + (xp[16]@u128 * yp[0]@u128)@u512 * 2**128 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + (r3@u65 + c@u65)@u512 * 2**192 + r4@u512 * 2**256 + r5@u512 * 2**320 = C0

  rax = *(uint64 *)(yp + 8)
  (uint128) rdx rax = rax * x2
  carry? r3 += rax
  rdx += 0 + carry
  carry? r3 += c
  c = 0
  c += rdx + carry

  #// var C1 = C0 + (xp[16]@u128 * yp[8]@u128)@u512 * 2**192
  #// cut r6 = 0 && r7 = 0 && x2 = xp[16] &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     A1 = A0 +
  #//         (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 +
  #//         (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256 &&
  #//     C0 = A1 + (xp[16]@u128 * yp[0]@u128)@u512 * 2**128 &&
  #//     C1 = C0 + (xp[16]@u128 * yp[8]@u128)@u512 * 2**192 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + (r4@u65 + c@u65)@u512 * 2**256 + r5@u512 * 2**320 = C1
  
  rax = *(uint64 *)(yp + 16)
  (uint128) rdx rax = rax * x2
  carry? r4 += rax
  rdx += 0 + carry
  carry? r4 += c
  c = 0
  c += rdx + carry

  #// var C2 = C1 + (xp[16]@u128 * yp[16]@u128)@u512 * 2**256
  #// cut r6 = 0 && r7 = 0 && x2 = xp[16] &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     A1 = A0 +
  #//         (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 +
  #//         (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256 &&
  #//     C0 = A1 + (xp[16]@u128 * yp[0]@u128)@u512 * 2**128 &&
  #//     C1 = C0 + (xp[16]@u128 * yp[8]@u128)@u512 * 2**192 &&
  #//     C2 = C1 + (xp[16]@u128 * yp[16]@u128)@u512 * 2**256 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + r4@u512 * 2**256 + (r5@u65 + c@u65)@u512 * 2**320 = C2

  rax = *(uint64 *)(yp + 24)
  (uint128) rdx rax = rax * x2
  carry? r5 += rax
  rdx += 0 + carry
  carry? r5 += c
  r6 += rdx + carry

  #// var C3 = C2 + (xp[16]@u128 * yp[24]@u128)@u512 * 2**320
  #// cut r7 = 0 &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     A1 = A0 +
  #//         (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 +
  #//         (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256 &&
  #//     C0 = A1 + (xp[16]@u128 * yp[0]@u128)@u512 * 2**128 &&
  #//     C1 = C0 + (xp[16]@u128 * yp[8]@u128)@u512 * 2**192 &&
  #//     C2 = C1 + (xp[16]@u128 * yp[16]@u128)@u512 * 2**256 &&
  #//     C3 = C2 + (xp[16]@u128 * yp[24]@u128)@u512 * 2**320 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + r4@u512 * 2**256 + r5@u512 * 2**320 + r6@u512 * 2**384 = C3

  #// var A2 = A1 +
  #//          (xp[16]@u128 * yp[0]@u128)@u512 * 2**128 + (xp[16]@u128 * yp[8]@u128)@u512 * 2**192 +
  #//          (xp[16]@u128 * yp[16]@u128)@u512 * 2**256 + (xp[16]@u128 * yp[24]@u128)@u512 * 2**320
  #// cut r7 = 0 &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     A1 = A0 +
  #//         (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 +
  #//         (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256 &&
  #//     A2 = A1 +
  #//          (xp[16]@u128 * yp[0]@u128)@u512 * 2**128 + (xp[16]@u128 * yp[8]@u128)@u512 * 2**192 +
  #//          (xp[16]@u128 * yp[16]@u128)@u512 * 2**256 + (xp[16]@u128 * yp[24]@u128)@u512 * 2**320 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + r4@u512 * 2**256 + r5@u512 * 2**320 + r6@u512 * 2**384 = A2

  x3 = *(uint64 *)(xp + 24)
  rax = *(uint64 *)(yp + 0)
  (uint128) rdx rax = rax * x3
  carry? r3 += rax
  c = 0
  c += rdx + carry

  #// var D0 = A2 + (xp[24]@u128 * yp[0]@u128)@u512 * 2**192
  #// cut r7 = 0 && x3 = xp[24] &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     A1 = A0 +
  #//         (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 +
  #//         (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256 &&
  #//     A2 = A1 +
  #//          (xp[16]@u128 * yp[0]@u128)@u512 * 2**128 + (xp[16]@u128 * yp[8]@u128)@u512 * 2**192 +
  #//          (xp[16]@u128 * yp[16]@u128)@u512 * 2**256 + (xp[16]@u128 * yp[24]@u128)@u512 * 2**320 &&
  #//     D0 = A2 + (xp[24]@u128 * yp[0]@u128)@u512 * 2**192 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + (r4@u65 + c@u65)@u512 * 2**256 + r5@u512 * 2**320 + r6@u512 * 2**384 = D0

  rax = *(uint64 *)(yp + 8)
  (uint128) rdx rax = rax * x3
  carry? r4 += rax
  rdx += 0 + carry
  carry? r4 += c
  c = 0
  c += rdx + carry

  #// var D1 = D0 + (xp[24]@u128 * yp[8]@u128)@u512 * 2**256
  #// cut r7 = 0 && x3 = xp[24] &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     A1 = A0 +
  #//         (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 +
  #//         (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256 &&
  #//     A2 = A1 +
  #//          (xp[16]@u128 * yp[0]@u128)@u512 * 2**128 + (xp[16]@u128 * yp[8]@u128)@u512 * 2**192 +
  #//          (xp[16]@u128 * yp[16]@u128)@u512 * 2**256 + (xp[16]@u128 * yp[24]@u128)@u512 * 2**320 &&
  #//     D0 = A2 + (xp[24]@u128 * yp[0]@u128)@u512 * 2**192 &&
  #//     D1 = D0 + (xp[24]@u128 * yp[8]@u128)@u512 * 2**256 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + r4@u512 * 2**256 + (r5@u65 + c@u65)@u512 * 2**320 + r6@u512 * 2**384 = D1
  
  rax = *(uint64 *)(yp + 16)
  (uint128) rdx rax = rax * x3
  carry? r5 += rax
  rdx += 0 + carry
  carry? r5 += c
  c = 0
  c += rdx + carry

  #// var D2 = D1 + (xp[24]@u128 * yp[16]@u128)@u512 * 2**320
  #// cut r7 = 0 && x3 = xp[24] &&
  #//     A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     A1 = A0 +
  #//         (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 +
  #//         (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256 &&
  #//     A2 = A1 +
  #//          (xp[16]@u128 * yp[0]@u128)@u512 * 2**128 + (xp[16]@u128 * yp[8]@u128)@u512 * 2**192 +
  #//          (xp[16]@u128 * yp[16]@u128)@u512 * 2**256 + (xp[16]@u128 * yp[24]@u128)@u512 * 2**320 &&
  #//     D0 = A2 + (xp[24]@u128 * yp[0]@u128)@u512 * 2**192 &&
  #//     D1 = D0 + (xp[24]@u128 * yp[8]@u128)@u512 * 2**256 &&
  #//     D2 = D1 + (xp[24]@u128 * yp[16]@u128)@u512 * 2**320 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + r4@u512 * 2**256 + r5@u512 * 2**320 + (r6@u65 + c@u65)@u512 * 2**384 = D2
  
  rax = *(uint64 *)(yp + 24)
  (uint128) rdx rax = rax * x3
  carry? r6 += rax
  rdx += 0 + carry
  carry? r6 += c
  r7 += rdx + carry

  #// var D3 = D2 + (xp[24]@u128 * yp[24]@u128)@u512 * 2**384
  #// cut A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     A1 = A0 +
  #//         (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 +
  #//         (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256 &&
  #//     A2 = A1 +
  #//          (xp[16]@u128 * yp[0]@u128)@u512 * 2**128 + (xp[16]@u128 * yp[8]@u128)@u512 * 2**192 +
  #//          (xp[16]@u128 * yp[16]@u128)@u512 * 2**256 + (xp[16]@u128 * yp[24]@u128)@u512 * 2**320 &&
  #//     D0 = A2 + (xp[24]@u128 * yp[0]@u128)@u512 * 2**192 &&
  #//     D1 = D0 + (xp[24]@u128 * yp[8]@u128)@u512 * 2**256 &&
  #//     D2 = D1 + (xp[24]@u128 * yp[16]@u128)@u512 * 2**320 &&
  #//     D3 = D2 + (xp[24]@u128 * yp[24]@u128)@u512 * 2**384 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + r4@u512 * 2**256 + r5@u512 * 2**320 + r6@u512 * 2**384 + r7@u512 * 2**448 = D3

  #// var A3 = A2 +
  #//         (xp[24]@u128 * yp[0]@u128)@u512 * 2**192 + (xp[24]@u128 * yp[8]@u128)@u512 * 2**256 +
  #//         (xp[24]@u128 * yp[16]@u128)@u512 * 2**320 + (xp[24]@u128 * yp[24]@u128)@u512 * 2**384
  #// cut A0 = (xp[0]@u128 * yp[0]@u128)@u512 + (xp[0]@u128 * yp[8]@u128)@u512 * 2**64 +
  #//          (xp[0]@u128 * yp[16]@u128)@u512 * 2**128 + (xp[0]@u128 * yp[24]@u128)@u512 * 2**192 &&
  #//     A1 = A0 +
  #//         (xp[8]@u128 * yp[0]@u128)@u512 * 2**64 + (xp[8]@u128 * yp[8]@u128)@u512 * 2**128 +
  #//         (xp[8]@u128 * yp[16]@u128)@u512 * 2**192 + (xp[8]@u128 * yp[24]@u128)@u512 * 2**256 &&
  #//     A2 = A1 +
  #//          (xp[16]@u128 * yp[0]@u128)@u512 * 2**128 + (xp[16]@u128 * yp[8]@u128)@u512 * 2**192 +
  #//          (xp[16]@u128 * yp[16]@u128)@u512 * 2**256 + (xp[16]@u128 * yp[24]@u128)@u512 * 2**320 &&
  #//     A3 = A2 +
  #//         (xp[24]@u128 * yp[0]@u128)@u512 * 2**192 + (xp[24]@u128 * yp[8]@u128)@u512 * 2**256 +
  #//         (xp[24]@u128 * yp[16]@u128)@u512 * 2**320 + (xp[24]@u128 * yp[24]@u128)@u512 * 2**384 &&
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192 + r4@u512 * 2**256 + r5@u512 * 2**320 + r6@u512 * 2**384 + r7@u512 * 2**448 = A3

###################################################################
# The following should hold at this point:
#
# (x0 + 2^64*x1 + 2^128*x2 + 2^192*x3) * (y0 + 2^64*x1 + 2^128*y2 + 2^192*y3) = (r0 + 2^64*r1 + 2^128*r2 + 2^192*r3 + 2^256*r4 + 2^320*r5 + 2^384*r6 + 2^448*r7)
#
###################################################################

  #// cut true

  #// var r0_0 = r0
  #//     r1_0 = r1
  #//     r2_0 = r2
  #//     r3_0 = r3
  #//     r4_0 = r4
  #//     r5_0 = r5
  #//     r6_0 = r6
  #//     r7_0 = r7
  #//     r8_0 = r8

  rax = r4
  (uint128) rdx rax = rax * *(uint64 *)&crypto_sign_ed25519_amd64_64_38
  
  r4 = rax
  rax = r5
  r5 = rdx
  
  (uint128) rdx rax = rax * *(uint64 *)&crypto_sign_ed25519_amd64_64_38
  
  carry? r5 += rax
  rax = r6
  r6 = 0
  r6 += rdx + carry
  
  (uint128) rdx rax = rax * *(uint64 *)&crypto_sign_ed25519_amd64_64_38
  
  carry? r6 += rax
  rax = r7
  r7 = 0
  r7 += rdx + carry
  
  (uint128) rdx rax = rax * *(uint64 *)&crypto_sign_ed25519_amd64_64_38
  
  carry? r7 += rax
  r8 = 0
  r8 += rdx + carry

  carry? r0 += r4
  carry? r1 += r5 + carry
  carry? r2 += r6 + carry
  carry? r3 += r7 + carry
  
  zero = 0
  r8 += zero + carry

  #// var r0_1 = r0
  #//     r1_1 = r1
  #//     r2_1 = r2
  #//     r3_1 = r3
  #//     r4_1 = r4
  #//     r5_1 = r5
  #//     r6_1 = r6
  #//     r7_1 = r7
  #//     r8_1 = r8

  #// cut (r0_0@u140 + 38 * r4_0@u140)@u512 + (r1_0@u140 + 38 * r5_0@u140)@u512 * 2**64 + (r2_0@u140 + 38 * r6_0@u140)@u512 * 2**128 +
  #//       (r3_0@u140 + 38 * r7_0@u140)@u512 * 2**192 =
  #//     r0_1@u512 + r1_1@u512 * 2**64 + r2_1@u512 * 2**128 + r3_1@u512 * 2**192 + r8_1@u512 * 2**256 &&
  #//     r0_1 = r0 &&
  #//     r1_1 = r1 &&
  #//     r2_1 = r2 &&
  #//     r3_1 = r3 &&
  #//     r4_1 = r4 &&
  #//     r5_1 = r5 &&
  #//     r6_1 = r6 &&
  #//     r7_1 = r7 &&
  #//     r8_1 = r8 &&
  #//     0 <=u r8 <u 2**7 &&
  #//     zero = 0

  r8 *= 38
  carry? r0 += r8
  carry? r1 += zero + carry
  carry? r2 += zero + carry
  carry? r3 += zero + carry

  #// var r0_2 = r0
  #//     r1_2 = r1
  #//     r2_2 = r2
  #//     r3_2 = r3
  #//     r8_2 = r8

  #// cut (r0_1@u140 + 38 * r8_1@u140)@u512 + r1_1@u512 * 2**64 + r2_1@u512 * 2**128 + r3_1@u512 * 2**192 =
  #//     r0_2@u512 + r1_2@u512 * 2**64 + r2_2@u512 * 2**128 + r3_2@u512 * 2**192 + carry@u512 * 2**256 &&
  #//     r0_2 = r0 &&
  #//     r1_2 = r1 &&
  #//     r2_2 = r2 &&
  #//     r3_2 = r3 &&
  #//     r4_1 = r4 &&
  #//     r5_1 = r5 &&
  #//     r6_1 = r6 &&
  #//     r7_1 = r7 &&
  #//     r8_2 = r8 &&
  #//     0 <=u r8 <u 2**13 &&
  #//     zero = 0 &&
  #//     (carry = 1 || carry = 0)

  zero += zero + carry
  zero *= 38
  r0 += zero

  #// cut (r0_2@u140 + 38 * carry@u140)@u512 + r1_2@u512 * 2**64 + r2_2@u512 * 2**128 + r3_2@u512 * 2**192 =
  #//     r0@u512 + r1@u512 * 2**64 + r2@u512 * 2**128 + r3@u512 * 2**192

###################################################################
# The following should hold at this point:
#
# (x0 + 2^64*x1 + 2^128*x2 + 2^192*x3) * (y0 + 2^64*x1 + 2^128*y2 + 2^192*y3) congruent (r0 + 2^64*r1 + 2^128*r2 + 2^192*r3) (modulo 2^255-19)
#
###################################################################
 
*(uint64 *)(rp + 8) = r1
*(uint64 *)(rp + 16) = r2
*(uint64 *)(rp + 24) = r3
*(uint64 *)(rp + 0) = r0


  caller1 = caller1_stack
  caller2 = caller2_stack
  caller3 = caller3_stack
  caller4 = caller4_stack
  caller5 = caller5_stack
  caller6 = caller6_stack
  caller7 = caller7_stack


leave
