# This file verifies fe25519_sq in radix 2^64. Four of the verification
# conditions have to be proved without -a.

# CPU: Intel(R) Xeon(R) CPU X5675 @ 3.07GHz
# RAM: 32GB
# Configuration: -c consts -s -a
# With Boolector 1.6.0 (-minisat): 3m11.780s + 0m4.889s (five VCs re-verified without -a)

int64 rp
int64 xp

input rp
input xp

int64 r0
int64 r1
int64 r2
int64 r3


  #BEGIN MACRO callerregs_declare
  int64 caller1
  int64 caller2
  int64 caller3
  int64 caller4
  int64 caller5
  int64 caller6
  int64 caller7
  caller caller1
  caller caller2
  caller caller3
  caller caller4
  caller caller5
  caller caller6
  caller caller7
  stack64 caller1_stack
  stack64 caller2_stack
  stack64 caller3_stack
  stack64 caller4_stack
  stack64 caller5_stack
  stack64 caller6_stack
  stack64 caller7_stack
  #END MACRO callerregs_declare


# Required for the square template
int64 squarer4
int64 squarer5
int64 squarer6
int64 squarer7
int64 squarer8
int64 squarerax
int64 squarerdx
int64 squaret1
int64 squaret2
int64 squaret3
int64 squarec
int64 squarezero
int64 squarei38

enter fe25519_sq

###################################################################
# Conditions on the inputs: x0 = *(uint64 *)(xp +  0),
#                           x1 = *(uint64 *)(xp +  8),
#                           x2 = *(uint64 *)(xp + 16),
#                           x3 = *(uint64 *)(xp + 24) are all arbitrary 64-bit unsigned integers
#
###################################################################

  #BEGIN MACRO callerregs_save
  caller1_stack = caller1
  caller2_stack = caller2
  caller3_stack = caller3
  caller4_stack = caller4
  caller5_stack = caller5
  caller6_stack = caller6
  caller7_stack = caller7
  #END MACRO callerregs_save

  #BEGIN MACRO square
  squarer7 = 0
  
  squarerax = *(uint64 *)(xp + 8)
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)(xp + 0)
  r1 = squarerax
  r2 = squarerdx

  #// var A0 = xp[8]@u513 * xp[0]@u513 * 2**64
  #// cut squarer7 = 0 &&
  #//     A0 = xp[8]@u513 * xp[0]@u513 * 2**64 &&
  #//     r1@u513 * 2**64 + r2@u513 * 2**128 = A0 &&
  #//     r2 <u (2**64 - 1)

  squarerax = *(uint64 *)(xp + 16)
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)(xp + 8)
  r3 = squarerax 
  squarer4 = squarerdx

  #// var A1 = A0 + xp[16]@u513 * xp[8]@u513 * 2**192
  #// cut squarer7 = 0 &&
  #//     A0 = xp[8]@u513 * xp[0]@u513 * 2**64 &&
  #//     A1 = A0 + xp[16]@u513 * xp[8]@u513 * 2**192 &&
  #//     r1@u513 * 2**64 + r2@u513 * 2**128 + r3@u513 * 2**192 + squarer4@u513 * 2**256 = A1 &&
  #//     r2 <u (2**64 - 1) &&
  #//     squarer4 <u (2**64 - 1)
  
  squarerax = *(uint64 *)(xp + 24)
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)(xp + 16)
  squarer5 = squarerax
  squarer6 = squarerdx
  
  #// var A2 = A1 + xp[24]@u513 * xp[16]@u513 * 2**320
  #// cut squarer7 = 0 &&
  #//     A0 = xp[8]@u513 * xp[0]@u513 * 2**64 &&
  #//     A1 = A0 + xp[16]@u513 * xp[8]@u513 * 2**192 &&
  #//     A2 = A1 + xp[24]@u513 * xp[16]@u513 * 2**320 &&
  #//     r1@u513 * 2**64 + r2@u513 * 2**128 + r3@u513 * 2**192 + squarer4@u513 * 2**256 + squarer5@u513 * 2**320 + squarer6@u513 * 2**384 = A2 &&
  #//     r2 <u (2**64 - 1) &&
  #//     squarer4 <u (2**64 - 1) &&
  #//     squarer6 <u (2**64 - 1)
  
  squarerax = *(uint64 *)(xp + 16)
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)(xp + 0)
  carry? r2 += squarerax
  carry? r3 += squarerdx + carry
  squarer4 += 0 + carry

  #// var A3 = A2 + xp[16]@u513 * xp[0]@u513 * 2**128
  #// cut squarer7 = 0 &&
  #//     A0 = xp[8]@u513 * xp[0]@u513 * 2**64 &&
  #//     A1 = A0 + xp[16]@u513 * xp[8]@u513 * 2**192 &&
  #//     A2 = A1 + xp[24]@u513 * xp[16]@u513 * 2**320 &&
  #//     A3 = A2 + xp[16]@u513 * xp[0]@u513 * 2**128 &&
  #//     r1@u513 * 2**64 + r2@u513 * 2**128 + r3@u513 * 2**192 + squarer4@u513 * 2**256 + squarer5@u513 * 2**320 + squarer6@u513 * 2**384 = A3 &&
  #//     squarer6 <u (2**64 - 1)

  squarerax = *(uint64 *)(xp + 24)
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)(xp + 8)
  carry? squarer4 += squarerax
  carry? squarer5 += squarerdx + carry
  squarer6 += 0 + carry

  #// var A4 = A3 + xp[24]@u513 * xp[8]@u513 * 2**256
  #// cut squarer7 = 0 &&
  #//     A0 = xp[8]@u513 * xp[0]@u513 * 2**64 &&
  #//     A1 = A0 + xp[16]@u513 * xp[8]@u513 * 2**192 &&
  #//     A2 = A1 + xp[24]@u513 * xp[16]@u513 * 2**320 &&
  #//     A3 = A2 + xp[16]@u513 * xp[0]@u513 * 2**128 &&
  #//     A4 = A3 + xp[24]@u513 * xp[8]@u513 * 2**256 &&
  #//     r1@u513 * 2**64 + r2@u513 * 2**128 + r3@u513 * 2**192 + squarer4@u513 * 2**256 + squarer5@u513 * 2**320 + squarer6@u513 * 2**384 = A4
  
  squarerax = *(uint64 *)(xp + 24)
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)(xp + 0)
  carry? r3 += squarerax
  carry? squarer4 += squarerdx + carry
  carry? squarer5 += 0 + carry
  carry? squarer6 += 0 + carry
  squarer7 += 0 + carry

  # squarer7 <=u 1 && (squarer7 = 1 -> (squarer5 = 0 && squarer6 = 0)) has to be proved without -a
  #// var A5 = A4 + xp[24]@u513 * xp[0]@u513 * 2**192
  #// cut A0 = xp[8]@u513 * xp[0]@u513 * 2**64 &&
  #//     A1 = A0 + xp[16]@u513 * xp[8]@u513 * 2**192 &&
  #//     A2 = A1 + xp[24]@u513 * xp[16]@u513 * 2**320 &&
  #//     A3 = A2 + xp[16]@u513 * xp[0]@u513 * 2**128 &&
  #//     A4 = A3 + xp[24]@u513 * xp[8]@u513 * 2**256 &&
  #//     A5 = A4 + xp[24]@u513 * xp[0]@u513 * 2**192 &&
  #//     r1@u513 * 2**64 + r2@u513 * 2**128 + r3@u513 * 2**192 + squarer4@u513 * 2**256 + squarer5@u513 * 2**320 + squarer6@u513 * 2**384 + squarer7@u513 * 2**448 = A5 &&
  #//     squarer7 <=u 1 && (squarer7 = 1 -> (squarer5 = 0 && squarer6 = 0))
  
  carry? r1 += r1
  carry? r2 += r2 + carry
  carry? r3 += r3 + carry
  carry? squarer4 += squarer4 + carry
  carry? squarer5 += squarer5 + carry
  carry? squarer6 += squarer6 + carry
  squarer7 += squarer7 + carry

  #// var A6 = A5 + A5
  #// cut A0 = xp[8]@u513 * xp[0]@u513 * 2**64 &&
  #//     A1 = A0 + xp[16]@u513 * xp[8]@u513 * 2**192 &&
  #//     A2 = A1 + xp[24]@u513 * xp[16]@u513 * 2**320 &&
  #//     A3 = A2 + xp[16]@u513 * xp[0]@u513 * 2**128 &&
  #//     A4 = A3 + xp[24]@u513 * xp[8]@u513 * 2**256 &&
  #//     A5 = A4 + xp[24]@u513 * xp[0]@u513 * 2**192 &&
  #//     A6 = A5 + A5 &&
  #//     r1@u513 * 2**64 + r2@u513 * 2**128 + r3@u513 * 2**192 + squarer4@u513 * 2**256 + squarer5@u513 * 2**320 + squarer6@u513 * 2**384 + squarer7@u513 * 2**448 = A6 &&
  #//     squarer7 <=u 1 && (squarer7 = 1 -> squarer6 <=u (2**64 - 2))

  squarerax = *(uint64 *)(xp + 0)
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)(xp + 0)
  r0 = squarerax
  squaret1 = squarerdx

  #// var A7 = A6 + xp[0]@u513 * xp[0]@u513
  #// cut A0 = xp[8]@u513 * xp[0]@u513 * 2**64 &&
  #//     A1 = A0 + xp[16]@u513 * xp[8]@u513 * 2**192 &&
  #//     A2 = A1 + xp[24]@u513 * xp[16]@u513 * 2**320 &&
  #//     A3 = A2 + xp[16]@u513 * xp[0]@u513 * 2**128 &&
  #//     A4 = A3 + xp[24]@u513 * xp[8]@u513 * 2**256 &&
  #//     A5 = A4 + xp[24]@u513 * xp[0]@u513 * 2**192 &&
  #//     A6 = A5 + A5 &&
  #//     A7 = A6 + xp[0]@u513 * xp[0]@u513 &&
  #//     r0@u513 + (r1@u65 + squaret1@u65)@u513 * 2**64 + r2@u513 * 2**128 + r3@u513 * 2**192 +
  #//       squarer4@u513 * 2**256 + squarer5@u513 * 2**320 + squarer6@u513 * 2**384 + squarer7@u513 * 2**448 = A7 &&
  #//     squarer7 <=u 1 && (squarer7 = 1 -> squarer6 <=u (2**64 - 2))

  squarerax = *(uint64 *)(xp + 8)
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)(xp + 8)
  squaret2 = squarerax
  squaret3 = squarerdx

  #// var A8 = A7 + xp[8]@u513 * xp[8]@u513 * 2**128
  #// cut A0 = xp[8]@u513 * xp[0]@u513 * 2**64 &&
  #//     A1 = A0 + xp[16]@u513 * xp[8]@u513 * 2**192 &&
  #//     A2 = A1 + xp[24]@u513 * xp[16]@u513 * 2**320 &&
  #//     A3 = A2 + xp[16]@u513 * xp[0]@u513 * 2**128 &&
  #//     A4 = A3 + xp[24]@u513 * xp[8]@u513 * 2**256 &&
  #//     A5 = A4 + xp[24]@u513 * xp[0]@u513 * 2**192 &&
  #//     A6 = A5 + A5 &&
  #//     A7 = A6 + xp[0]@u513 * xp[0]@u513 &&
  #//     A8 = A7 + xp[8]@u513 * xp[8]@u513 * 2**128 &&
  #//     r0@u513 + (r1@u65 + squaret1@u65)@u513 * 2**64 + (r2@u65 + squaret2@u65)@u513 * 2**128 + (r3@u65 + squaret3@u65)@u513 * 2**192 +
  #//       squarer4@u513 * 2**256 + squarer5@u513 * 2**320 + squarer6@u513 * 2**384 + squarer7@u513 * 2**448 = A8 &&
  #//     squarer7 <=u 1 && (squarer7 = 1 -> squarer6 <=u (2**64 - 2))
  
  squarerax = *(uint64 *)(xp + 16)
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)(xp + 16)
  carry? r1 += squaret1
  carry? r2 += squaret2 + carry
  carry? r3 += squaret3 + carry
  carry? squarer4 += squarerax + carry
  carry? squarer5 += squarerdx + carry
  carry? squarer6 += 0 + carry
  squarer7 += 0 + carry 

  # squarer7 <=u 1 && (squarer7 = 1 -> squarer6 <=u (2**64 - 2)) has to be proved without -a
  #// var A9 = A8 + xp[16]@u513 * xp[16]@u513 * 2**256
  #// cut A0 = xp[8]@u513 * xp[0]@u513 * 2**64 &&
  #//     A1 = A0 + xp[16]@u513 * xp[8]@u513 * 2**192 &&
  #//     A2 = A1 + xp[24]@u513 * xp[16]@u513 * 2**320 &&
  #//     A3 = A2 + xp[16]@u513 * xp[0]@u513 * 2**128 &&
  #//     A4 = A3 + xp[24]@u513 * xp[8]@u513 * 2**256 &&
  #//     A5 = A4 + xp[24]@u513 * xp[0]@u513 * 2**192 &&
  #//     A6 = A5 + A5 &&
  #//     A7 = A6 + xp[0]@u513 * xp[0]@u513 &&
  #//     A8 = A7 + xp[8]@u513 * xp[8]@u513 * 2**128 &&
  #//     A9 = A8 + xp[16]@u513 * xp[16]@u513 * 2**256 &&
  #//     r0@u513 + r1@u513 * 2**64 + r2@u513 * 2**128 + r3@u513 * 2**192 +
  #//       squarer4@u513 * 2**256 + squarer5@u513 * 2**320 + squarer6@u513 * 2**384 + squarer7@u513 * 2**448 = A9 &&
  #//     squarer7 <=u 1 && (squarer7 = 1 -> squarer6 <=u (2**64 - 2))

  squarerax = *(uint64 *)(xp + 24)
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)(xp + 24)
  carry? squarer6 += squarerax
  squarer7 += squarerdx + carry

  #// var A10 = A9 + xp[24]@u513 * xp[24]@u513 * 2**384
  #// cut A0 = xp[8]@u513 * xp[0]@u513 * 2**64 &&
  #//     A1 = A0 + xp[16]@u513 * xp[8]@u513 * 2**192 &&
  #//     A2 = A1 + xp[24]@u513 * xp[16]@u513 * 2**320 &&
  #//     A3 = A2 + xp[16]@u513 * xp[0]@u513 * 2**128 &&
  #//     A4 = A3 + xp[24]@u513 * xp[8]@u513 * 2**256 &&
  #//     A5 = A4 + xp[24]@u513 * xp[0]@u513 * 2**192 &&
  #//     A6 = A5 + A5 &&
  #//     A7 = A6 + xp[0]@u513 * xp[0]@u513 &&
  #//     A8 = A7 + xp[8]@u513 * xp[8]@u513 * 2**128 &&
  #//     A9 = A8 + xp[16]@u513 * xp[16]@u513 * 2**256 &&
  #//     A10 = A9 + xp[24]@u513 * xp[24]@u513 * 2**384 &&
  #//     r0@u513 + r1@u513 * 2**64 + r2@u513 * 2**128 + r3@u513 * 2**192 +
  #//       squarer4@u513 * 2**256 + squarer5@u513 * 2**320 + squarer6@u513 * 2**384 + squarer7@u513 * 2**448 = A10

  # This has to be proved without -a
  #// cut r0@u513 + r1@u513 * 2**64 + r2@u513 * 2**128 + r3@u513 * 2**192 +
  #//       squarer4@u513 * 2**256 + squarer5@u513 * 2**320 + squarer6@u513 * 2**384 + squarer7@u513 * 2**448 = (xp[8]@u513 * xp[0]@u513 * 2**64 + xp[16]@u513 * xp[8]@u513 * 2**192 + xp[24]@u513 * xp[16]@u513 * 2**320 + xp[16]@u513 * xp[0]@u513 * 2**128 + xp[24]@u513 * xp[8]@u513 * 2**256 + xp[24]@u513 * xp[0]@u513 * 2**192) + (xp[8]@u513 * xp[0]@u513 * 2**64 + xp[16]@u513 * xp[8]@u513 * 2**192 + xp[24]@u513 * xp[16]@u513 * 2**320 + xp[16]@u513 * xp[0]@u513 * 2**128 + xp[24]@u513 * xp[8]@u513 * 2**256 + xp[24]@u513 * xp[0]@u513 * 2**192) + xp[0]@u513 * xp[0]@u513 + xp[8]@u513 * xp[8]@u513 * 2**128 + xp[16]@u513 * xp[16]@u513 * 2**256 + xp[24]@u513 * xp[24]@u513 * 2**384
   
###################################################################
# The following should hold at this point:
#
# (x0 + 2^64*x1 + 2^128*x2 + 2^192*x3)^2 = (squarer0 + 2^64*squarer1 + 2^128*squarer2 + 2^192*squarer3 + 2^256*squarer4 + 2^320*squarer5 + 2^384*squarer6 + 2^448*squarer7)
#
###################################################################

  #// cut true

  #// var r0_0 = r0
  #//     r1_0 = r1
  #//     r2_0 = r2
  #//     r3_0 = r3
  #//     squarer4_0 = squarer4
  #//     squarer5_0 = squarer5
  #//     squarer6_0 = squarer6
  #//     squarer7_0 = squarer7
  #//     squarer8_0 = squarer8

  squarerax = squarer4
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)&crypto_sign_ed25519_amd64_64_38
  
  squarer4 = squarerax
  squarerax = squarer5
  squarer5 = squarerdx
  
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)&crypto_sign_ed25519_amd64_64_38
  
  carry? squarer5 += squarerax
  squarerax = squarer6
  squarer6 = 0
  squarer6 += squarerdx + carry
  
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)&crypto_sign_ed25519_amd64_64_38
  
  carry? squarer6 += squarerax
  squarerax = squarer7
  squarer7 = 0
  squarer7 += squarerdx + carry
  
  (uint128) squarerdx squarerax = squarerax * *(uint64 *)&crypto_sign_ed25519_amd64_64_38
  
  carry? squarer7 += squarerax
  squarer8 = 0
  squarer8 += squarerdx + carry
  
  carry? r0 += squarer4
  carry? r1 += squarer5 + carry
  carry? r2 += squarer6 + carry
  carry? r3 += squarer7 + carry
  
  squarezero = 0
  squarer8 += squarezero + carry

  #// var r0_1 = r0
  #//     r1_1 = r1
  #//     r2_1 = r2
  #//     r3_1 = r3
  #//     squarer4_1 = squarer4
  #//     squarer5_1 = squarer5
  #//     squarer6_1 = squarer6
  #//     squarer7_1 = squarer7
  #//     squarer8_1 = squarer8

  #// cut (r0_0@u140 + 38 * squarer4_0@u140)@u513 + (r1_0@u140 + 38 * squarer5_0@u140)@u513 * 2**64 + (r2_0@u140 + 38 * squarer6_0@u140)@u513 * 2**128 +
  #//       (r3_0@u140 + 38 * squarer7_0@u140)@u513 * 2**192 =
  #//     r0_1@u513 + r1_1@u513 * 2**64 + r2_1@u513 * 2**128 + r3_1@u513 * 2**192 + squarer8_1@u513 * 2**256 &&
  #//     r0_1 = r0 &&
  #//     r1_1 = r1 &&
  #//     r2_1 = r2 &&
  #//     r3_1 = r3 &&
  #//     squarer4_1 = squarer4 &&
  #//     squarer5_1 = squarer5 &&
  #//     squarer6_1 = squarer6 &&
  #//     squarer7_1 = squarer7 &&
  #//     squarer8_1 = squarer8 &&
  #//     0 <=u squarer8 <u 2**7 &&
  #//     squarezero = 0

  squarer8 *= 38
  carry? r0 += squarer8
  carry? r1 += squarezero + carry
  carry? r2 += squarezero + carry
  carry? r3 += squarezero + carry

  #// var r0_2 = r0
  #//     r1_2 = r1
  #//     r2_2 = r2
  #//     r3_2 = r3
  #//     squarer8_2 = squarer8

  #// cut (r0_1@u140 + 38 * squarer8_1@u140)@u513 + r1_1@u513 * 2**64 + r2_1@u513 * 2**128 + r3_1@u513 * 2**192 =
  #//     r0_2@u513 + r1_2@u513 * 2**64 + r2_2@u513 * 2**128 + r3_2@u513 * 2**192 + carry@u513 * 2**256 &&
  #//     r0_2 = r0 &&
  #//     r1_2 = r1 &&
  #//     r2_2 = r2 &&
  #//     r3_2 = r3 &&
  #//     squarer4_1 = squarer4 &&
  #//     squarer5_1 = squarer5 &&
  #//     squarer6_1 = squarer6 &&
  #//     squarer7_1 = squarer7 &&
  #//     squarer8_2 = squarer8 &&
  #//     0 <=u squarer8 <u 2**13 &&
  #//     squarezero = 0 &&
  #//     (carry = 1 || carry = 0)

  squarezero += squarezero + carry
  squarezero *= 38
  r0 += squarezero

  #// cut (r0_2@u140 + 38 * carry@u140)@u513 + r1_2@u513 * 2**64 + r2_2@u513 * 2**128 + r3_2@u513 * 2**192 =
  #//     r0@u513 + r1@u513 * 2**64 + r2@u513 * 2**128 + r3@u513 * 2**192

  #END MACRO square


###################################################################
# The following should hold at this point:
#
# (x0 + 2^64*x1 + 2^128*x2 + 2^192*x3)^2 congruent (r0 + 2^64*r1 + 2^128*r2 + 2^192*r3) (modulo 2^255-19)
#
###################################################################


*(uint64 *)(rp + 8) = r1
*(uint64 *)(rp + 16) = r2
*(uint64 *)(rp + 24) = r3
*(uint64 *)(rp + 0) = r0

  #BEGIN MACRO callerregs_restore
  caller1 = caller1_stack
  caller2 = caller2_stack
  caller3 = caller3_stack
  caller4 = caller4_stack
  caller5 = caller5_stack
  caller6 = caller6_stack
  caller7 = caller7_stack
  #END MACRO callerregs_restore


leave
