# CPU: Intel(R) Xeon(R) CPU X5675 @ 3.07GHz
# RAM: 32GB
# Configuration: -c consts -s
# With Boolector 1.6.0 (-minisat): 0m12.753s

int64 rp
int64 xp

input rp
input xp

int64 r0
int64 r1
int64 r2
int64 r3
int64 r4

#required for  macro
int64 rax
int64 rdx


  #BEGIN MACRO callerregs_declare
  int64 caller1
  int64 caller2
  int64 caller3
  int64 caller4
  int64 caller5
  int64 caller6
  int64 caller7
  caller caller1
  caller caller2
  caller caller3
  caller caller4
  caller caller5
  caller caller6
  caller caller7
  stack64 caller1_stack
  stack64 caller2_stack
  stack64 caller3_stack
  stack64 caller4_stack
  stack64 caller5_stack
  stack64 caller6_stack
  stack64 caller7_stack
  #END MACRO callerregs_declare


enter fe25519_mul121666


  #BEGIN MACRO callerregs_save
  caller1_stack = caller1
  caller2_stack = caller2
  caller3_stack = caller3
  caller4_stack = caller4
  caller5_stack = caller5
  caller6_stack = caller6
  caller7_stack = caller7
  #END MACRO callerregs_save

###################################################################
# Conditions on the inputs: x0 = *(uint64 *)(xp +  0),
#                           x1 = *(uint64 *)(xp +  8),
#                           x2 = *(uint64 *)(xp + 16),
#                           x3 = *(uint64 *)(xp + 24),
#                           x4 = *(uint64 *)(xp + 32), are all in [0,2^64-1] (whole uint64 range)
#
###################################################################

  #BEGIN MACRO 
  rax = *(uint64 *)(xp + 0)
  (uint128) rdx rax = rax * *(uint64 *) &crypto_sign_ed25519_amd64_51_121666_213
  (uint64) rax >>= 13

  #// var rdx0 = rdx
  #//     rax0 = rax

  r0 = rax
  r1 = rdx

  #// cut rax0@u320 + rdx0@u320 * 2**51 = mem64[xp + 0]@u320 * 121666 &&
  #//     r0 = rax0 && r1 = rdx0 &&
  #//     0 <=u r0 <u 2**51 &&
  #//     0 <=u r1 <u 2**30 &&
  #//     0 <=u rax0 <=u 2**51 &&
  #//     0 <=u rdx0 <=u 2**30

  rax = *(uint64 *)(xp + 8)
  (uint128) rdx rax = rax * *(uint64 *) &crypto_sign_ed25519_amd64_51_121666_213
  (uint64) rax >>= 13

  #// var rdx1 = rdx
  #//     rax1 = rax

  r1 += rax
  r2 = rdx

  #// cut rax0@u320 + rdx0@u320 * 2**51 = mem64[xp + 0]@u320 * 121666 &&
  #//     rax1@u320 + rdx1@u320 * 2**51 = mem64[xp + 8]@u320 * 121666 &&
  #//     r0 = rax0 && r1 = rdx0 + rax1 && r2 = rdx1 &&
  #//     0 <=u r0 <u 2**51 &&
  #//     0 <=u r1 <u 2**52 &&
  #//     0 <=u r2 <u 2**30 &&
  #//     0 <=u rax0 <=u 2**51 &&
  #//     0 <=u rdx0 <=u 2**30 &&
  #//     0 <=u rax1 <=u 2**51 &&
  #//     0 <=u rdx1 <=u 2**30

  rax = *(uint64 *)(xp + 16)
  (uint128) rdx rax = rax * *(uint64 *) &crypto_sign_ed25519_amd64_51_121666_213
  (uint64) rax >>= 13

  #// var rdx2 = rdx
  #//     rax2 = rax

  r2 += rax
  r3 = rdx

  #// cut rax0@u320 + rdx0@u320 * 2**51 = mem64[xp + 0]@u320 * 121666 &&
  #//     rax1@u320 + rdx1@u320 * 2**51 = mem64[xp + 8]@u320 * 121666 &&
  #//     rax2@u320 + rdx2@u320 * 2**51 = mem64[xp + 16]@u320 * 121666 &&
  #//     r0 = rax0 && r1 = rdx0 + rax1 && r2 = rdx1 + rax2 && r3 = rdx2 &&
  #//     0 <=u r0 <u 2**51 &&
  #//     0 <=u r1 <u 2**52 &&
  #//     0 <=u r2 <u 2**52 &&
  #//     0 <=u r3 <u 2**30 &&
  #//     0 <=u rax0 <=u 2**51 &&
  #//     0 <=u rdx0 <=u 2**30 &&
  #//     0 <=u rax1 <=u 2**51 &&
  #//     0 <=u rdx1 <=u 2**30 &&
  #//     0 <=u rax2 <=u 2**51 &&
  #//     0 <=u rdx2 <=u 2**30

  rax = *(uint64 *)(xp + 24)
  (uint128) rdx rax = rax * *(uint64 *) &crypto_sign_ed25519_amd64_51_121666_213
  (uint64) rax >>= 13

  #// var rdx3 = rdx
  #//     rax3 = rax

  r3 += rax
  r4 = rdx

  #// cut rax0@u320 + rdx0@u320 * 2**51 = mem64[xp + 0]@u320 * 121666 &&
  #//     rax1@u320 + rdx1@u320 * 2**51 = mem64[xp + 8]@u320 * 121666 &&
  #//     rax2@u320 + rdx2@u320 * 2**51 = mem64[xp + 16]@u320 * 121666 &&
  #//     rax3@u320 + rdx3@u320 * 2**51 = mem64[xp + 24]@u320 * 121666 &&
  #//     r0 = rax0 && r1 = rdx0 + rax1 && r2 = rdx1 + rax2 && r3 = rdx2 + rax3 && r4 = rdx3 &&
  #//     0 <=u r0 <u 2**51 &&
  #//     0 <=u r1 <u 2**52 &&
  #//     0 <=u r2 <u 2**52 &&
  #//     0 <=u r3 <u 2**52 &&
  #//     0 <=u r4 <u 2**30 &&
  #//     0 <=u rax0 <=u 2**51 &&
  #//     0 <=u rdx0 <=u 2**30 &&
  #//     0 <=u rax1 <=u 2**51 &&
  #//     0 <=u rdx1 <=u 2**30 &&
  #//     0 <=u rax2 <=u 2**51 &&
  #//     0 <=u rdx2 <=u 2**30 &&
  #//     0 <=u rax3 <=u 2**51 &&
  #//     0 <=u rdx3 <=u 2**30

  rax = *(uint64 *)(xp + 32)
  (uint128) rdx rax = rax * *(uint64 *) &crypto_sign_ed25519_amd64_51_121666_213
  (uint64) rax >>= 13

  #// var rdx4 = rdx
  #//     rax4 = rax

  r4 += rax

  #// cut rax0@u320 + rdx0@u320 * 2**51 = mem64[xp + 0]@u320 * 121666 &&
  #//     rax1@u320 + rdx1@u320 * 2**51 = mem64[xp + 8]@u320 * 121666 &&
  #//     rax2@u320 + rdx2@u320 * 2**51 = mem64[xp + 16]@u320 * 121666 &&
  #//     rax3@u320 + rdx3@u320 * 2**51 = mem64[xp + 24]@u320 * 121666 &&
  #//     rax4@u320 + rdx4@u320 * 2**51 = mem64[xp + 32]@u320 * 121666 &&
  #//     r0 = rax0 && r1 = rdx0 + rax1 && r2 = rdx1 + rax2 && r3 = rdx2 + rax3 && r4 = rdx3 + rax4 &&
  #//     0 <=u r0 <u 2**51 &&
  #//     0 <=u r1 <u 2**52 &&
  #//     0 <=u r2 <u 2**52 &&
  #//     0 <=u r3 <u 2**52 &&
  #//     0 <=u r4 <u 2**52 &&
  #//     0 <=u rax0 <=u 2**51 &&
  #//     0 <=u rdx0 <=u 2**30 &&
  #//     0 <=u rax1 <=u 2**51 &&
  #//     0 <=u rdx1 <=u 2**30 &&
  #//     0 <=u rax2 <=u 2**51 &&
  #//     0 <=u rdx2 <=u 2**30 &&
  #//     0 <=u rax3 <=u 2**51 &&
  #//     0 <=u rdx3 <=u 2**30 &&
  #//     0 <=u rax4 <=u 2**51 &&
  #//     0 <=u rdx4 <u 2**30 &&
  #//     rdx = rdx4

  # var lhs = (mem64[xp + 0]@u320 + mem64[xp + 8]@u320 * 2**51 + mem64[xp + 16]@u320 * 2**102 + mem64[xp + 24]@u320 * 2**153 + mem64[xp + 32]@u320 * 2**204) * 121666
  #     rhs = r0@u320 + r1@u320 * 2**51 + r2@u320 * 2**102 + r3@u320 * 2**153 + r4@u320 * 2**204 + rdx@u320 * 2**255

  rdx *= 19
  r0 += rdx
  #END MACRO 

  #// cut rax0@u320 + rdx0@u320 * 2**51 = mem64[xp + 0]@u320 * 121666 &&
  #//     rax1@u320 + rdx1@u320 * 2**51 = mem64[xp + 8]@u320 * 121666 &&
  #//     rax2@u320 + rdx2@u320 * 2**51 = mem64[xp + 16]@u320 * 121666 &&
  #//     rax3@u320 + rdx3@u320 * 2**51 = mem64[xp + 24]@u320 * 121666 &&
  #//     rax4@u320 + rdx4@u320 * 2**51 = mem64[xp + 32]@u320 * 121666 &&
  #//     r0 = rax0 + 19 * rdx4 && r1 = rdx0 + rax1 && r2 = rdx1 + rax2 && r3 = rdx2 + rax3 && r4 = rdx3 + rax4 &&
  #//     0 <=u r0 <u 2**52 &&
  #//     0 <=u r1 <u 2**52 &&
  #//     0 <=u r2 <u 2**52 &&
  #//     0 <=u r3 <u 2**52 &&
  #//     0 <=u r4 <u 2**52 &&
  #//     0 <=u rax0 <=u 2**51 &&
  #//     0 <=u rdx0 <=u 2**30 &&
  #//     0 <=u rax1 <=u 2**51 &&
  #//     0 <=u rdx1 <=u 2**30 &&
  #//     0 <=u rax2 <=u 2**51 &&
  #//     0 <=u rdx2 <=u 2**30 &&
  #//     0 <=u rax3 <=u 2**51 &&
  #//     0 <=u rdx3 <=u 2**30 &&
  #//     0 <=u rax4 <=u 2**51 &&
  #//     0 <=u rdx4 <u 2**30

###################################################################
# The following should hold at this point:
#
# (x0 + 2^51*x1 + 2^102*x2 + 2^153*x3 + 2^204*x4) * 121666 congruent to (r0 + r1*2^51 + r2*2^102 + r3*2^153 + r4*2^204)  [modulo 2^255-19]
#
# r0l,r1l,r2l,r3l,r4l are all in [0,2^52]
#
###################################################################
 

*(uint64 *)(rp + 0) = r0
*(uint64 *)(rp + 8) = r1
*(uint64 *)(rp + 16) = r2
*(uint64 *)(rp + 24) = r3
*(uint64 *)(rp + 32) = r4


  #BEGIN MACRO callerregs_restore
  caller1 = caller1_stack
  caller2 = caller2_stack
  caller3 = caller3_stack
  caller4 = caller4_stack
  caller5 = caller5_stack
  caller6 = caller6_stack
  caller7 = caller7_stack
  #END MACRO callerregs_restore


leave
