# CPU: Intel(R) Xeon(R) CPU X5675 @ 3.07GHz
# RAM: 32GB
# Configuration: -c consts
# With Boolector 1.6.0 (-m -v -minisat): 141m22.062s (1: 117m44.108s, 2: 23m37.954s)

int64 x0
int64 x1

int64 r0
int64 r1
int64 r2
int64 r3

int64 rax
int64 rdx

int64 t

int64 mask

enter gfe_mul

  # ********** Inputs **********
  #// var xp0 = mem64[input_1 + 0]
  #//     xp1 = mem64[input_1 + 8]
  #//     yp0 = mem64[input_2 + 0]
  #//     yp1 = mem64[input_2 + 8]

  # ********** Precondition **********
  #// assume (0 <=u xp0 <=u 2**64 - 1) && (0 <=u xp1 <u 2**63) &&
  #//        (0 <=u yp0 <=u 2**64 - 1) && (0 <=u yp1 <u 2**63)

  input_2 = input_2

  x0 = mem64[input_1 + 0]
  rax = mem64[input_2 + 0]
  (uint128) rdx rax = rax * x0
  r0 = rax
  r1 = rdx
  
  rax = mem64[input_2 + 8]
  (uint128) rdx rax = rax * x0
  carry? r1 += rax
  r2 = 0
  r2 += rdx + carry
  
  x1 = mem64[input_1 + 8]
  rax = mem64[input_2 + 0]
  (uint128) rdx rax = rax * x1
  carry? r1 += rax
  r2  += rdx + carry

  rax = mem64[input_2 + 8]
  (uint128) rdx rax = rax * x1
  carry? r2 += rax
  r3 = 0
  r3 += rdx + carry

  # Note: Define x0y0 as (xp0@u128 * yp0@u128)@u256 instead of (xp0@u256 * yp0@u256) makes the problem easier.
  #// var x0y0 = (xp0@u128 * yp0@u128)@u256
  #//     x0y1 = (xp0@u128 * yp1@u128)@u256
  #//     x1y0 = (xp1@u128 * yp0@u128)@u256
  #//     x1y1 = (xp1@u128 * yp1@u128)@u256
  #// const (2**64)@u256 (2**128)@u256 (2**192)@u256
  #// var lhs = x0y0 + (x0y1 + x1y0) * 2**64 + x1y1 * 2**128
  #//     rhs = r0@u256 + r1@u256 * 2**64 + r2@u256 * 2**128 + r3@u256 * 2**192
  #// assert lhs = rhs
  #// cut 0 <=u r3 <u 2**62

  # ********** Remember the initial values of r's **********
  #// var r0i = r0@u256
  #//     r1i = r1@u256
  #//     r2i = r2@u256
  #//     r3i = r3@u256

  r3 = (r3.r2) << 1
  r2 = (r2.r1) << 1

  # mask63 = 0x7fffffffffffffff
  mask = mem64[mask63]

  r1 &= mask
  carry? r0 += r2
  r1 += r3 + carry

  t = r1
  (uint64) t >>= 63
  r1 &= mask

  carry? r0 += t
  t = 0
  r1 += t + carry

  # ********** Extends final r's to 256 bits **********
  #// var r0' = r0@u256
  #//     r1' = r1@u256

  # ********** Define some constants **********
  #// const (2 ** 64)@u256
  #//       (2 ** 128)@u256
  #//       (2 ** 192)@u256
  #//       (2 ** 127 - 1)@u256

  # ********** Assertion **********
  #// var lhs = r0i + r1i * 2**64 + r2i * 2**128 + r3i * 2**192
  #//     rhs = r0' + r1'@u256 * 2**64
  #// assert (lhs - rhs) %u (2**127 - 1) = 0

  mem64[input_0 + 0] = r0
  mem64[input_0 + 8] = r1
 
return
