Require Import ZArith .
Require Import Znumtheory .

Local Open Scope Z_scope .

Definition modulo (a b n : Z) : Prop := (n | (a - b)) .
Notation "( a == b [ n ])" := (modulo a b n) .

Lemma modulo_refl : forall a n : Z, (a == a [ n ]) .
intros a n .
red .
rewrite Zminus_diag .
apply Zdivide_0 .
Qed .

Lemma modulo_symm : forall a b n : Z, (a == b [ n ]) -> (b == a [ n ]) .
intros a b n Hab .
red in Hab |- * .
apply Zdivide_opp_r_rev .
cut (- (b - a) = a - b) . 
  intros H . 
  rewrite H . 
  trivial .

  unfold Zminus .
  rewrite Zopp_plus_distr .
  rewrite Zopp_involutive .
  rewrite Zplus_comm .
  trivial .
Qed .

Lemma modulo_tran : forall a b c n : Z, 
  (a == b [ n ]) -> (b == c [ n ]) -> (a == c [ n ]) .
intros a b c n Hab Hbc .
red in Hab, Hbc |- * .
cut (a - c = a - b + (b - c)) .
  intros H .
  rewrite H .
  apply Zdivide_plus_r .
    trivial .
    trivial .

  auto with * .
Qed .

Lemma modulo_plus_comm : forall a b n : Z, (a + b == b + a [ n ]) .
intros a b c .
red .
rewrite Zplus_comm .
rewrite Zminus_diag .
auto with * .
Qed .

Lemma modulo_plus_assoc : forall a b c n : Z, (a + b + c == a + (b + c) [ n ]) .
intros a b c n .
red .
rewrite Zplus_assoc .
rewrite Zminus_diag .
auto with * .
Qed .

Lemma modulo_plus_substr : forall a b c n : Z,
  (a == b [ n ]) -> (a + c == b + c [ n ]) .
intros a b c n Hab .
red in Hab |- * .
cut (a + c - (b + c) = a - b) .
  intros H .
  rewrite H .
  trivial .

  auto with * .
Qed .

Lemma modulo_plus_substl : forall a b c n : Z,
  (a == b [ n ]) -> (c + a == c + b [ n ]) .
intros a b c n Hab .
red in Hab |- * .
cut (c + a - (c + b) = a - b) .
  intros H .
  rewrite H .
  trivial .

  auto with * .
Qed .

Lemma modulo_plus_subst : forall a b c d n : Z,
  (a == b [ n ]) -> (c == d [ n ]) -> (a + c == b + d [ n ]) .
intros a b c d n H0 H1 .
red .
red in H0 .
red in H1 .
cut (a + c - (b + d) = (a - b) + (c - d)) .
  intros HH; rewrite HH .
  apply Zdivide_plus_r; trivial .

  ring .
Qed .

Lemma modulo_mult_comm : forall a b n : Z, (a * b == b * a [ n ]) .
intros a b c .
red .
rewrite Zmult_comm .
rewrite Zminus_diag .
auto with * .
Qed .

Lemma modulo_mult_assoc : forall a b c n : Z, (a * b * c == a * (b * c) [ n ]) .
intros a b c n .
red .
rewrite Zmult_assoc .
rewrite Zminus_diag .
auto with * .
Qed .

Lemma modulo_mult_substr : forall a b c n : Z,
  (a == b [ n ]) -> (a * c == b * c [ n ]) .
intros a b c n Hab .
red in Hab |- * .
cut (a * c - b * c = (a - b) * c) .
  intros H .
  rewrite H .
  auto with * .

  rewrite Zmult_minus_distr_r .
  trivial .
Qed .

Lemma modulo_mult_substl : forall a b c n : Z,
  (a == b [ n ]) -> (c * a == c * b [ n ]) .
intros a b c n Hab .
red in Hab |- * .
cut (c * a - c * b = c * (a - b)) .
  intros H .
  rewrite H .
  auto with * .

  rewrite Zmult_minus_distr_l .
  auto with * .
Qed .

Lemma modulo_mult_subst : forall a b c d n : Z,
  (a == b [ n ]) -> (c == d [ n ]) -> (a * c == b * d [ n ]) .
intros a b c d n H0 H1 .
red in H0, H1 |- * .
cut (a * c - b * d = (a - b) * c + b * (c - d)) .
  intros HH; rewrite HH; clear HH .
  auto with * .

  ring .
Qed .
