Require Import ZArith .
Require Import Znumtheory .
Require Export Modulo .

Local Open Scope Z_scope .
  
Variable D : Z .
Hypothesis radix : D = 2^51 .

Lemma D519 : (D^5 == 19 [ 2^255 - 19 ]) .
rewrite radix .
red .
auto with * .
Qed .

Ltac r_bound bd :=
  split;
  [
    repeat ((apply Zplus_le_0_compat || apply Zmult_le_0_compat); auto with *)
  |
    apply Zlt_trans with bd;
    repeat ((apply Zplus_lt_compat || apply Zmult_lt_compat); auto with *);
    split;
    [
      repeat ((apply Zplus_le_0_compat || apply Zmult_le_0_compat); auto with *)
    |
      repeat ((apply Zplus_lt_compat || apply Zmult_lt_compat); auto with *)
    ]
  ] .

Lemma v0_eq :
  forall x0 x1 x2 x3 x4 y0 y1 y2 y3 y4 v0 : Z,
    (0 <= x0 /\ x0 < 2 ^ 51) /\ (0 <= x1 /\ x1 < 2 ^ 51) /\
    (0 <= x2 /\ x2 < 2 ^ 51) /\ (0 <= x3 /\ x3 < 2 ^ 51) /\
    (0 <= x4 /\ x4 < 2 ^ 51) /\
    (0 <= y0 /\ y0 < 2 ^ 51) /\ (0 <= y1 /\ y1 < 2 ^ 51) /\
    (0 <= y2 /\ y2 < 2 ^ 51) /\ (0 <= y3 /\ y3 < 2 ^ 51) /\
    (0 <= y4 /\ y4 < 2 ^ 51) /\
    (v0 = (x0*y0 + 19*(x1*y4 + x2*y3 + x3*y2 + x4*y1)) mod 2 ^ 129) ->
    v0 = x0*y0 + 19*(x1*y4 + x2*y3 + x3*y2 + x4*y1) .
intros .
decompose [ and ] H; clear H .
rewrite H20; apply Zmod_small .
r_bound (2 ^ 51 * 2 ^ 51 + 20 * 
  (2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51)) .
Qed .

Lemma v1_eq :
  forall x0 x1 x2 x3 x4 y0 y1 y2 y3 y4 v1 : Z,
    (0 <= x0 < 2 ^ 51) /\ (0 <= x1 < 2 ^ 51) /\ (0 <= x2 < 2 ^ 51) /\ 
    (0 <= x3 < 2 ^ 51) /\ (0 <= x4 < 2 ^ 51) /\
    (0 <= y0 < 2 ^ 51) /\ (0 <= y1 < 2 ^ 51) /\ (0 <= y2 < 2 ^ 51) /\ 
    (0 <= y3 < 2 ^ 51) /\ (0 <= y4 < 2 ^ 51) /\
    (v1 = (x0*y1 + x1*y0 + 19*(x2*y4 + x3*y3 + x4*y2)) mod 2 ^ 129) ->
    v1 = x0*y1 + x1*y0 + 19*(x2*y4 + x3*y3 + x4*y2) .
intros .
decompose [ and ] H; clear H .
rewrite H20; apply Zmod_small .
r_bound (2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51 + 20 * 
  (2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51)) .
Qed .

Lemma v2_eq :
  forall x0 x1 x2 x3 x4 y0 y1 y2 y3 y4 v2 : Z,
    (0 <= x0 /\ x0 < 2 ^ 51) /\ (0 <= x1 /\ x1 < 2 ^ 51) /\
    (0 <= x2 /\ x2 < 2 ^ 51) /\ (0 <= x3 /\ x3 < 2 ^ 51) /\
    (0 <= x4 /\ x4 < 2 ^ 51) /\
    (0 <= y0 /\ y0 < 2 ^ 51) /\ (0 <= y1 /\ y1 < 2 ^ 51) /\
    (0 <= y2 /\ y2 < 2 ^ 51) /\ (0 <= y3 /\ y3 < 2 ^ 51) /\
    (0 <= y4 /\ y4 < 2 ^ 51) /\
    (v2 = (x0*y2 + x1*y1 + x2*y0 + 19 * (x3*y4 + x4*y3)) mod 2 ^ 129) ->
    v2 = x0*y2 + x1*y1 + x2*y0 + 19 * (x3*y4 + x4*y3) .
intros .
decompose [ and ] H; clear H .
rewrite H20; apply Zmod_small .
r_bound (2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51 +
  20 * (2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51)) .
Qed .

Lemma v3_eq :
  forall x0 x1 x2 x3 x4 y0 y1 y2 y3 y4 v3 : Z,
    (0 <= x0 /\ x0 < 2 ^ 51) /\ (0 <= x1 /\ x1 < 2 ^ 51) /\
    (0 <= x2 /\ x2 < 2 ^ 51) /\ (0 <= x3 /\ x3 < 2 ^ 51) /\
    (0 <= x4 /\ x4 < 2 ^ 51) /\
    (0 <= y0 /\ y0 < 2 ^ 51) /\ (0 <= y1 /\ y1 < 2 ^ 51) /\
    (0 <= y2 /\ y2 < 2 ^ 51) /\ (0 <= y3 /\ y3 < 2 ^ 51) /\
    (0 <= y4 /\ y4 < 2 ^ 51) /\
    (v3 = (x0*y3 + x1*y2 + x2*y1 + x3*y0 + 19*x4*y4) mod 2 ^ 129) ->
    v3 = x0*y3 + x1*y2 + x2*y1 + x3*y0 + 19*x4*y4 .
intros .
decompose [ and ] H; clear H .
rewrite H20; apply Zmod_small .
split;
[
  repeat ((apply Zplus_le_0_compat || apply Zmult_le_0_compat); auto with *)
|
  apply Zlt_trans with (2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51 +
                        2 ^ 51 * 2 ^ 51 + 20 * 2 ^ 51 * 2 ^ 51);
  [
    repeat ((apply Zplus_lt_compat || apply Zmult_lt_compat); auto with *)
  |
    compute; trivial
  ]
] .
Qed .

Lemma v4_eq :
  forall x0 x1 x2 x3 x4 y0 y1 y2 y3 y4 v4 : Z,
    (0 <= x0 /\ x0 < 2 ^ 51) /\ (0 <= x1 /\ x1 < 2 ^ 51) /\
    (0 <= x2 /\ x2 < 2 ^ 51) /\ (0 <= x3 /\ x3 < 2 ^ 51) /\
    (0 <= x4 /\ x4 < 2 ^ 51) /\
    (0 <= y0 /\ y0 < 2 ^ 51) /\ (0 <= y1 /\ y1 < 2 ^ 51) /\
    (0 <= y2 /\ y2 < 2 ^ 51) /\ (0 <= y3 /\ y3 < 2 ^ 51) /\
    (0 <= y4 /\ y4 < 2 ^ 51) /\
    (v4 = (x0*y4 + x1*y3 + x2*y2 + x3*y1 + x4*y0) mod 2 ^ 129) ->
    v4 = x0*y4 + x1*y3 + x2*y2 + x3*y1 + x4*y0 .
intros .
decompose [ and ] H; clear H .
rewrite H20; apply Zmod_small .
split;
[
  repeat ((apply Zplus_le_0_compat || apply Zmult_le_0_compat); auto with *)
|
  apply Zlt_trans with (2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51 +
                        2 ^ 51 * 2 ^ 51 + 2 ^ 51 * 2 ^ 51);
  [
    repeat ((apply Zplus_lt_compat || apply Zmult_lt_compat); auto with *)
  |
    compute; trivial
  ]
] .
Qed .

Ltac d519tac eqn :=
  cut eqn;
  [
    intros HH; rewrite HH; clear HH;
    repeat (apply modulo_mult_substr);
    apply D519
  |
    ring
  ] .

Fact moduloD519 : 
forall x y : Z, (x * y * D ^ 5 == 19 * x * y [ 2 ^255 - 19 ]) .
intros x y .
d519tac (x * y * D ^ 5 = D ^ 5 * x * y) .
Qed .

Fact moduloD619 : 
forall x y : Z, (x * y * D ^ 6 == 19 * x * y * D [ 2 ^255 - 19 ]) .
intros x y .
d519tac (x * y * D ^ 6 = D ^ 5 * x * y * D) .
Qed .

Fact moduloD719 :
forall x y : Z, (x * y * D ^ 7 == 19 * x * y * D ^ 2 [ 2 ^255 - 19 ]) .
intros x y .
d519tac (x * y * D ^ 7 = D ^ 5 * x * y * D ^ 2) .
Qed .

Fact moduloD819 :
forall x y : Z, (x * y * D ^ 8 == 19 * x * y * D ^ 3 [ 2 ^255 - 19 ]) .
intros x y .
d519tac (x * y * D ^ 8 = D ^ 5 * x * y * D ^ 3) .
Qed .

Ltac elimD519 x y :=
  cut (x * y * D ^ 5 == 19 * x * y [ 2 ^255 - 19 ]);
  [
    intros HH; apply (modulo_plus_subst _ _ _ _ _ HH); clear HH
  |
    apply (moduloD519 x y)
  ] .

Ltac elimD619 x y :=
  cut (x * y * D ^ 6 == 19 * x * y * D [ 2 ^255 - 19 ]);
  [
    intros HH; apply (modulo_plus_subst _ _ _ _ _ HH); clear HH
  |
    apply (moduloD619 x y)
  ] .

Ltac elimD719 x y :=
  cut (x * y * D ^ 7 == 19 * x * y * D ^ 2 [ 2 ^255 - 19 ]);
  [
    intros HH; apply (modulo_plus_subst _ _ _ _ _ HH); clear HH
  |
    apply (moduloD719 x y)
  ] .

Ltac elimD819 x y :=
  cut (x * y * D ^ 8 == 19 * x * y * D ^ 3 [ 2 ^255 - 19 ]);
  [
    intros HH; apply (modulo_plus_subst _ _ _ _ _ HH); clear HH
  |
    apply (moduloD819 x y)
  ] .

Lemma reasoning :
  forall x0 x1 x2 x3 x4 y0 y1 y2 y3 y4
    v0 v1 v2 v3 v4 s0 s1 s2 s3 s4 : Z,
    (0 <= x0 /\ x0 < 2 ^ 51) /\ (0 <= x1 /\ x1 < 2 ^ 51) /\
    (0 <= x2 /\ x2 < 2 ^ 51) /\ (0 <= x3 /\ x3 < 2 ^ 51) /\
    (0 <= x4 /\ x4 < 2 ^ 51) /\
    (0 <= y0 /\ y0 < 2 ^ 51) /\ (0 <= y1 /\ y1 < 2 ^ 51) /\
    (0 <= y2 /\ y2 < 2 ^ 51) /\ (0 <= y3 /\ y3 < 2 ^ 51) /\
    (0 <= y4 /\ y4 < 2 ^ 51) /\
    (v0 = (x0*y0 + 19*(x1*y4 + x2*y3 + x3*y2 + x4*y1)) mod 2 ^ 129) /\ 
    (v1 = (x0*y1 + x1*y0 + 19*(x2*y4 + x3*y3 + x4*y2)) mod 2 ^ 129) /\
    (v2 = (x0*y2 + x1*y1 + x2*y0 + 19*(x3*y4 + x4*y3)) mod 2 ^ 129) /\ 
    (v3 = (x0*y3 + x1*y2 + x2*y1 + x3*y0 + 19*x4*y4) mod 2 ^ 129) /\
    (v4 = (x0*y4 + x1*y3 + x2*y2 + x3*y1 + x4*y0) mod 2 ^ 129) /\
    ((v0 + v1 * D + v2 * D^2 + v3 * D^3 + v4 * D^4) == 
     (s0 + s1 * D + s2 * D^2 + s3 * D^3 + s4 * D^4) [ 2^255 - 19 ])
    ->
    ((x0 + x1 * D + x2 * D^2 + x3 * D^3 + x4 * D^4) *
     (y0 + y1 * D + y2 * D^2 + y3 * D^3 + y4 * D^4) ==
     (s0 + s1 * D + s2 * D^2 + s3 * D^3 + s4 * D^4) [ 2^255 - 19 ]) .
Proof .
intros .
decompose [ and ] H; clear H .
apply modulo_tran with (v0 + v1 * D + v2 * D ^ 2 + v3 * D ^ 3 + v4 * D ^ 4); 
  trivial; clear H26 .
cut (v0 = x0 * y0 + 19 * (x1 * y4 + x2 * y3 + x3 * y2 + x4 * y1) /\
     v1 = x0 * y1 + x1 * y0 + 19 * (x2 * y4 + x3 * y3 + x4 * y2) /\
     v2 = x0 * y2 + x1 * y1 + x2 * y0 + 19 * (x3 * y4 + x4 * y3) /\
     v3 = x0 * y3 + x1 * y2 + x2 * y1 + x3 * y0 + 19 * x4 * y4 /\
     v4 = x0 * y4 + x1 * y3 + x2 * y2 + x3 * y1 + x4 * y0) .
intros HH; decompose [ and ] HH; intros; clear HH .
rewrite H, H26, H25, H27, H29; clear H H26 H25 H27 H29 .

cut ((x0 + x1 * D + x2 * D ^ 2 + x3 * D ^ 3 + x4 * D ^ 4) *
     (y0 + y1 * D + y2 * D ^ 2 + y3 * D ^ 3 + y4 * D ^ 4) =
     x0 * y0 + 
     x1 * y4 * D ^ 5 + x2 * y3 * D ^ 5 + x3 * y2 * D ^ 5 + x4 * y1 * D ^ 5 +
     x0 * y1 * D + x1 * y0 * D + 
     x2 * y4 * D ^ 6 + x3 * y3 * D ^ 6 + x4 * y2 * D ^ 6 + 
     x0 * y2 * D ^ 2 + x1 * y1 * D ^ 2 + x2 * y0 * D ^ 2 + 
     x3 * y4 * D ^ 7 + x4 * y3 * D ^ 7 +
     x0 * y3 * D ^ 3 + x1 * y2 * D ^ 3 + x2 * y1 * D ^ 3 + x3 * y0 * D ^ 3 + 
     x4 * y4 * D ^ 8 +
     x0 * y4 * D ^ 4 + x1 * y3 * D ^ 4 + x2 * y2 * D ^ 4 + x3 * y1 * D ^ 4 + 
     x4 * y0 * D ^ 4);
[
  intros HHH; rewrite HHH; clear HHH
|
  ring
] .

repeat (rewrite Zmult_plus_distr_r || rewrite Zmult_plus_distr_l ||
        rewrite Zmult_assoc || rewrite Zplus_assoc_reverse) .

repeat (
    apply modulo_plus_substl || apply modulo_refl ||
    elimD519 x1 y4 || elimD519 x2 y3 || elimD519 x3 y2 || elimD519 x4 y1 ||
    elimD619 x2 y4 || elimD619 x3 y3 || elimD619 x4 y2 ||
    elimD719 x3 y4 || elimD719 x4 y3 ||
    elimD819 x4 y4
) .

repeat split;
repeat (
  (apply (v0_eq x0 x1 x2 x3 x4 y0 y1 y2 y3 y4 v0) ||
   apply (v1_eq x0 x1 x2 x3 x4 y0 y1 y2 y3 y4 v1) ||
   apply (v2_eq x0 x1 x2 x3 x4 y0 y1 y2 y3 y4 v2) ||
   apply (v3_eq x0 x1 x2 x3 x4 y0 y1 y2 y3 y4 v3) ||
   apply (v4_eq x0 x1 x2 x3 x4 y0 y1 y2 y3 y4 v4)); 
   repeat split; trivial) .
Qed .

Quit .
