
(** the type of bit size *)
type bbits = int

(** the type of variables *)
type bvar = int

(** the type of statements *)
type bstmt =
| Bcomment of string
| Bempty
| Bone of bvar * bbits
| Bones of bvar * bbits
| Bzero of bvar * bbits
| Bconstd of bvar * bbits * string
| Bconsth of bvar * bbits * string
| Bconst of bvar * bbits * string
| Bvar of bvar * bbits * string option
| Bnot of bvar * bbits * bvar
| Bneg of bvar * bbits * bvar
| Bredand of bvar * bbits * bvar
| Bredor of bvar * bbits * bvar
| Bredxor of bvar * bbits * bvar
| Binc of bvar * bbits * bvar
| Bdec of bvar * bbits * bvar
| Band of bvar * bbits * bvar * bvar
| Bor of bvar * bbits * bvar * bvar
| Bxor of bvar * bbits * bvar * bvar
| Bnand of bvar * bbits * bvar * bvar
| Bnor of bvar * bbits * bvar * bvar
| Bxnor of bvar * bbits * bvar * bvar
| Bimplies of bvar * bbits * bvar * bvar
| Biff of bvar * bbits * bvar * bvar
| Badd of bvar * bbits * bvar * bvar
| Bsub of bvar * bbits * bvar * bvar
| Bmul of bvar * bbits * bvar * bvar
| Burem of bvar * bbits * bvar * bvar
| Bsrem of bvar * bbits * bvar * bvar
| Budiv of bvar * bbits * bvar * bvar
| Bsdiv of bvar * bbits * bvar * bvar
| Bsmod of bvar * bbits * bvar * bvar
| Beq of bvar * bbits * bvar * bvar
| Bne of bvar * bbits * bvar * bvar
| Bult of bvar * bbits * bvar * bvar
| Bslt of bvar * bbits * bvar * bvar
| Bulte of bvar * bbits * bvar * bvar
| Bslte of bvar * bbits * bvar * bvar
| Bugt of bvar * bbits * bvar * bvar
| Bsgt of bvar * bbits * bvar * bvar
| Bugte of bvar * bbits * bvar * bvar
| Bsgte of bvar * bbits * bvar * bvar
| Bsll of bvar * bbits * bvar * bvar
| Bsrl of bvar * bbits * bvar * bvar
| Bsra of bvar * bbits * bvar * bvar
| Bror of bvar * bbits * bvar * bvar
| Brol of bvar * bbits * bvar * bvar
| Buaddo of bvar * bbits * bvar * bvar
| Bsaddo of bvar * bbits * bvar * bvar
| Busubo of bvar * bbits * bvar * bvar
| Bssubo of bvar * bbits * bvar * bvar
| Bumulo of bvar * bbits * bvar * bvar
| Bsmulo of bvar * bbits * bvar * bvar
| Bsdivo of bvar * bbits * bvar * bvar
| Bconcat of bvar * bbits * bvar * bvar
| Bcond of bvar * bbits * bvar * bvar * bvar
| Bslice of bvar * bbits * bvar * bvar * bvar
| Barray of bvar * bbits * bbits (* element bit-width, array size bit-width *)
| Bacond of bvar * bbits * bbits * bvar * bvar * bvar (* element bit-width, array size bit-width, condition, true-var, false-var *)
| Bwrite of bvar * bbits * bbits * bvar * bvar * bvar (* element bit-width, array size bit-width, array-var, index-var, value-var *)
| Bread of bvar * bbits * bvar * bvar (* bit-width, array-var, index-var *)
| Broot of bvar * bbits * bvar

(** the type of programs *)
type bprog

val string_of_bbits : bbits -> string
val string_of_bvar : bvar -> string
val string_of_bstmt : bstmt -> string
val string_of_bprog : bprog -> string

val mkcomment : string -> bstmt
val mkempty : unit -> bstmt
val mkone : bvar -> bbits -> bstmt
val mkones : bvar -> bbits -> bstmt
val mkzero : bvar -> bbits -> bstmt
val mkconstd : bvar -> bbits -> string -> bstmt
val mkconsth : bvar -> bbits -> string -> bstmt
val mkconst : bvar -> bbits -> string -> bstmt
val mkvar : bvar -> bbits -> bstmt
val mkvar2 : bvar -> bbits -> string -> bstmt
val mknot : bvar -> bbits -> bvar -> bstmt
val mkneg : bvar -> bbits -> bvar -> bstmt
val mkredand : bvar -> bbits -> bvar -> bstmt
val mkredor : bvar -> bbits -> bvar -> bstmt
val mkredxor : bvar -> bbits -> bvar -> bstmt
val mkinc : bvar -> bbits -> bvar -> bstmt
val mkdec : bvar -> bbits -> bvar -> bstmt
val mkand : bvar -> bbits -> bvar -> bvar -> bstmt
val mkor : bvar -> bbits -> bvar -> bvar -> bstmt
val mkxor : bvar -> bbits -> bvar -> bvar -> bstmt
val mknand : bvar -> bbits -> bvar -> bvar -> bstmt
val mknor : bvar -> bbits -> bvar -> bvar -> bstmt
val mkxnor : bvar -> bbits -> bvar -> bvar -> bstmt
val mkimplies : bvar -> bbits -> bvar -> bvar -> bstmt
val mkiff : bvar -> bbits -> bvar -> bvar -> bstmt
val mkadd : bvar -> bbits -> bvar -> bvar -> bstmt
val mksub : bvar -> bbits -> bvar -> bvar -> bstmt
val mkmul : bvar -> bbits -> bvar -> bvar -> bstmt
val mkurem : bvar -> bbits -> bvar -> bvar -> bstmt
val mksrem : bvar -> bbits -> bvar -> bvar -> bstmt
val mkudiv : bvar -> bbits -> bvar -> bvar -> bstmt
val mksdiv : bvar -> bbits -> bvar -> bvar -> bstmt
val mksmod : bvar -> bbits -> bvar -> bvar -> bstmt
val mkeq : bvar -> bbits -> bvar -> bvar -> bstmt
val mkne : bvar -> bbits -> bvar -> bvar -> bstmt
val mkult : bvar -> bbits -> bvar -> bvar -> bstmt
val mkslt : bvar -> bbits -> bvar -> bvar -> bstmt
val mkulte : bvar -> bbits -> bvar -> bvar -> bstmt
val mkslte : bvar -> bbits -> bvar -> bvar -> bstmt
val mkugt : bvar -> bbits -> bvar -> bvar -> bstmt
val mksgt : bvar -> bbits -> bvar -> bvar -> bstmt
val mkugte : bvar -> bbits -> bvar -> bvar -> bstmt
val mksgte : bvar -> bbits -> bvar -> bvar -> bstmt
val mksll : bvar -> bbits -> bvar -> bvar -> bstmt
val mksrl : bvar -> bbits -> bvar -> bvar -> bstmt
val mksra : bvar -> bbits -> bvar -> bvar -> bstmt
val mkror : bvar -> bbits -> bvar -> bvar -> bstmt
val mkrol : bvar -> bbits -> bvar -> bvar -> bstmt
val mkuaddo : bvar -> bbits -> bvar -> bvar -> bstmt
val mksaddo : bvar -> bbits -> bvar -> bvar -> bstmt
val mkusubo : bvar -> bbits -> bvar -> bvar -> bstmt
val mkssubo : bvar -> bbits -> bvar -> bvar -> bstmt
val mkumulo : bvar -> bbits -> bvar -> bvar -> bstmt
val mksmulo : bvar -> bbits -> bvar -> bvar -> bstmt
val mksdivo : bvar -> bbits -> bvar -> bvar -> bstmt
val mkconcat : bvar -> bbits -> bvar -> bvar -> bstmt
val mkcond : bvar -> bbits -> bvar -> bvar -> bvar -> bstmt
val mkslice : bvar -> bbits -> bvar -> bvar -> bvar -> bstmt
val mkarray : bvar -> bbits -> bbits -> bstmt
val mkacond : bvar -> bbits -> bbits -> bvar -> bvar -> bvar -> bstmt
val mkwrite : bvar -> bbits -> bbits -> bvar -> bvar -> bvar -> bstmt
val mkread : bvar -> bbits -> bvar -> bvar -> bstmt
val mkroot : bvar -> bbits -> bvar -> bstmt

val mkprog : bstmt list -> bprog

val stmtvar : bstmt -> bvar
val stmtsize : bstmt -> bbits
val varsize : bprog -> int -> bbits

val newid : bprog -> int
val addstmt : bprog -> bstmt -> unit
val addstmts : bprog -> bstmt list -> unit
val getstmts : bprog -> bstmt list
