
(** Supported formats for bit-vectors. *)
type format = Btor | STP | CVC3 | SMT2

(** Verification conditions represented in supported formats. *)
type vc

(** Generates verification conditions in the current output format. *)
val generate : ?cmap:(string, string) Hashtbl.t -> ?format:format -> ?split_conj:bool -> ?approximate:bool -> Qhasm.qprog -> vc list

(** Returns the string representations of verification conditions. *)
val string_of_vc : vc -> string

(** Returns the suggested file extension. *)
val ext : format -> string
